/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IVarIndex;
import org.beetl.core.statement.Type;
import org.beetl.core.statement.VarAttribute;

public class VarRef
extends Expression
implements IVarIndex {
    public VarAttribute[] attributes;
    public Expression safe;
    public int varIndex;
    public boolean hasSafe;
    private GrammarToken firstToken = null;

    public VarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token) {
        this(attributes, hasSafe, safe, token, token);
    }

    public VarRef(VarAttribute[] attributes, boolean hasSafe, Expression safe, GrammarToken token, GrammarToken firstToken) {
        super(token);
        this.attributes = attributes;
        this.safe = safe;
        this.hasSafe = hasSafe;
        this.firstToken = firstToken;
    }

    @Override
    public Object evaluate(Context ctx) {
        Object value = ctx.vars[this.varIndex];
        if (value == Context.NOT_EXIST_OBJECT) {
            if (this.hasSafe) {
                return this.safe == null ? null : this.safe.evaluate(ctx);
            }
            BeetlException ex = new BeetlException("VAR_NOT_DEFINED");
            ex.pushToken(this.firstToken);
            throw ex;
        }
        if (value == null && this.hasSafe) {
            return this.safe == null ? null : this.safe.evaluate(ctx);
        }
        if (this.attributes.length == 0) {
            return value;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            VarAttribute attr = this.attributes[i];
            if (value == null) {
                if (this.hasSafe) {
                    return this.safe == null ? null : this.safe.evaluate(ctx);
                }
                BeetlException be = new BeetlException("NULL", "\u7a7a\u6307\u9488");
                if (i == 0) {
                    be.pushToken(this.firstToken);
                } else {
                    be.pushToken(this.attributes[i - 1].token);
                }
                throw be;
            }
            try {
                value = attr.evaluate(ctx, value);
                continue;
            }
            catch (BeetlException ex) {
                ex.pushToken(attr.token);
                throw ex;
            }
            catch (RuntimeException ex) {
                BeetlException be = new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex);
                be.pushToken(attr.token);
                throw be;
            }
        }
        if (value == null && this.hasSafe) {
            return this.safe == null ? null : this.safe.evaluate(ctx);
        }
        return value;
    }

    public Object evaluateUntilLast(Context ctx) {
        if (this.attributes.length == 0) {
            throw new RuntimeException();
        }
        Object value = ctx.vars[this.varIndex];
        if (value == Context.NOT_EXIST_OBJECT) {
            BeetlException ex = new BeetlException("VAR_NOT_DEFINED");
            ex.pushToken(this.firstToken);
            throw ex;
        }
        if (value == null) {
            BeetlException ex = new BeetlException("NULL");
            ex.pushToken(this.firstToken);
            throw ex;
        }
        for (int i = 0; i < this.attributes.length - 1; ++i) {
            VarAttribute attr = this.attributes[i];
            if (value == null) {
                BeetlException be = new BeetlException("NULL", "\u7a7a\u6307\u9488");
                if (i == 0) {
                    be.pushToken(this.firstToken);
                } else {
                    be.pushToken(this.attributes[i - 1].token);
                }
                throw be;
            }
            try {
                value = attr.evaluate(ctx, value);
                continue;
            }
            catch (BeetlException ex) {
                ex.pushToken(attr.token);
                throw ex;
            }
            catch (RuntimeException ex) {
                BeetlException be = new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex);
                be.pushToken(attr.token);
                throw be;
            }
        }
        return value;
    }

    @Override
    public void setVarIndex(int index) {
        this.varIndex = index;
    }

    @Override
    public int getVarIndex() {
        return this.varIndex;
    }

    @Override
    public void infer(InferContext inferCtx) {
        Type type;
        Type lastType = type = inferCtx.types[this.varIndex];
        Type t = null;
        for (VarAttribute attr : this.attributes) {
            inferCtx.temp = lastType;
            attr.infer(inferCtx);
            t = lastType;
            lastType = attr.type;
            attr.type = t;
        }
        this.type = lastType;
        if (this.safe != null) {
            this.safe.infer(inferCtx);
            if (!this.safe.type.equals(this.type)) {
                this.type = Type.ObjectType;
            }
        }
    }
}

