/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.ConsoleErrorHandler;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.ext.fn.GetValueFunction;

public class BeetlKit {
    public static GroupTemplate gt;

    public static String render(String template, Map<String, Object> paras) {
        Template t = gt.getTemplate(template);
        t.binding(paras);
        return t.render();
    }

    public static void renderTo(String template, Writer writer, Map<String, Object> paras) {
        Template t = gt.getTemplate(template);
        t.binding(paras);
        t.renderTo(writer);
    }

    public static void execute(String script, Map<String, Object> paras) {
        BeetlKit.execute(script, paras, null);
    }

    public static Map execute(String script, Map<String, Object> paras, String[] locals) {
        String start = gt.getConf().getStatementStart();
        String end = gt.getConf().getStatementEnd();
        StringBuilder sb = new StringBuilder(script.length() + start.length() + end.length());
        sb.append(start).append(script);
        if (locals != null) {
            sb.append("beetlKit(");
            for (String varName : locals) {
                sb.append("'").append(varName).append("',").append(varName).append("!,");
            }
            sb.setLength(sb.length() - 1);
            sb.append(");");
        }
        sb.append(end);
        Template t = gt.getTemplate(sb.toString());
        t.binding(paras);
        HashMap map = new HashMap();
        t.binding("beetlKitMap", map);
        t.render();
        return map;
    }

    public static Map executeAndReturnRootScopeVars(String script) {
        String start = gt.getConf().getStatementStart();
        String end = gt.getConf().getStatementEnd();
        StringBuilder sb = new StringBuilder(script.length() + start.length() + end.length());
        sb.append(start).append(script);
        sb.append(end);
        Template t = gt.getTemplate(sb.toString());
        t.render();
        Map<String, Integer> idnexMap = t.program.metaData.getTemplateRootScopeIndexMap();
        Object[] values = t.ctx.vars;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Integer> entry : idnexMap.entrySet()) {
            String name = entry.getKey();
            int index = entry.getValue();
            Object value = values[index];
            result.put(name, value);
        }
        return result;
    }

    public static String testTemplate(String template, String initValue) {
        Map map = BeetlKit.executeAndReturnRootScopeVars(initValue);
        String result = BeetlKit.render(template, map);
        return result;
    }

    public static void main(String[] args) {
        String template = "${a}";
        String initValue = "var a=1,c=2+1";
        String result = BeetlKit.testTemplate(template, initValue);
        System.out.println(result);
    }

    static {
        Configuration cfg;
        gt = null;
        StringTemplateResourceLoader resourceLoader = new StringTemplateResourceLoader();
        try {
            cfg = Configuration.defaultConfiguration();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        gt = new GroupTemplate(resourceLoader, cfg);
        gt.registerFunction("beetlKit", new GetValueFunction());
        gt.setErrorHandler(new ConsoleErrorHandler(){

            @Override
            protected void println(Writer w, String msg) {
                try {
                    w.write(msg);
                    w.write(10);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected void print(Writer w, String msg) {
                try {
                    w.write(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected void printThrowable(Writer w, Throwable t) {
                t.printStackTrace(new PrintWriter(w));
            }

            @Override
            protected String getResourceName(String resourceId) {
                if (resourceId.length() > 10) {
                    return resourceId.substring(0, 10).concat("...");
                }
                return resourceId;
            }
        });
    }
}

