/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.query.GroupBy;
import org.beetl.sql.core.query.LambdaQuery;
import org.beetl.sql.core.query.OrderBy;
import org.beetl.sql.core.query.QueryCondition;
import org.beetl.sql.core.query.interfacer.QueryExecuteI;
import org.beetl.sql.core.query.interfacer.QueryOtherI;

public class Query<T>
extends QueryCondition<T>
implements QueryExecuteI<T>,
QueryOtherI<Query> {
    Class<T> clazz = null;
    StringTemplateResourceLoader tempLoader = new StringTemplateResourceLoader();

    public Query(SQLManager sqlManager, Class<T> clazz) {
        this.sqlManager = sqlManager;
        this.clazz = clazz;
    }

    public Query<T> condition() {
        return new Query<T>(this.sqlManager, this.clazz);
    }

    @Deprecated
    public LambdaQuery<T> lambda() {
        if (BeanKit.queryLambdasSupport) {
            if (this.sql != null || this.groupBy != null || this.orderBy != null) {
                throw new UnsupportedOperationException("LamdbaQuery\u5fc5\u987b\u5728\u8c03\u7528\u5176\u4ed6AP\u524d\u83b7\u53d6");
            }
            return new LambdaQuery(this.sqlManager, (Class)this.clazz);
        }
        throw new UnsupportedOperationException("\u9700\u8981\u4f7f\u7528Java8\u4ee5\u4e0a");
    }

    @Override
    public List<T> select(String ... columns) {
        StringBuilder sb = new StringBuilder("SELECT ");
        for (String column : columns) {
            sb.append(column).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" FROM ").append(this.getTableName(this.clazz)).append(" ").append((CharSequence)this.getSql());
        this.setSql(sb);
        this.addAdditionalPartSql();
        String targetSql = this.getSql().toString();
        Object[] paras = this.getParams().toArray();
        this.clear();
        List<T> list = this.sqlManager.execute(new SQLReady(targetSql, paras), this.clazz);
        return list;
    }

    @Override
    public T single() {
        List<T> list = ((Query)this.limit(this.getFirstRowNumber(), 1L)).select();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Map mapSingle() {
        List<Map> list = ((Query)this.limit(this.getFirstRowNumber(), 1L)).selectByType(Map.class);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public T unique() {
        List<T> list = ((Query)this.limit(this.getFirstRowNumber(), 2L)).select();
        if (list.isEmpty()) {
            throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6");
        }
        if (list.size() != 1) {
            throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u67e5\u8be2\u51fa\u591a\u6761\u7ed3\u679c\u96c6");
        }
        return list.get(0);
    }

    private int getFirstRowNumber() {
        return this.sqlManager.isOffsetStartZero() ? 0 : 1;
    }

    @Override
    public List<T> select() {
        return this.selectByType(this.clazz);
    }

    @Override
    public <K> List<K> select(Class<K> retType) {
        return this.selectByType(retType);
    }

    @Override
    public List<Map> mapSelect() {
        return this.selectByType(Map.class);
    }

    protected <K> List<K> selectByType(Class<K> retType) {
        StringBuilder sb = new StringBuilder("SELECT * ");
        sb.append("FROM ").append(this.getTableName(this.clazz)).append(" ").append((CharSequence)this.getSql());
        this.setSql(sb);
        this.addAdditionalPartSql();
        String targetSql = this.getSql().toString();
        Object[] paras = this.getParams().toArray();
        this.clear();
        List<K> list = this.sqlManager.execute(new SQLReady(targetSql, paras), retType);
        return list;
    }

    private void addAdditionalPartSql() {
        StringBuilder sb = this.getSql();
        if (this.orderBy != null) {
            sb.append(this.orderBy.getOrderBy()).append(" ");
        }
        if (this.groupBy != null) {
            sb.append(this.groupBy.getGroupBy()).append(" ");
        }
        if (this.startRow != -1L) {
            this.setSql(new StringBuilder(this.sqlManager.getDbStyle().getPageSQLStatement(this.getSql().toString(), this.startRow, this.pageSize)));
        }
    }

    @Override
    public int update(Object t) {
        SQLSource sqlSource = this.sqlManager.getDbStyle().genUpdateAbsolute(this.clazz);
        return this.handlerUpdateSql(t, sqlSource);
    }

    @Override
    public int updateSelective(Object t) {
        SQLSource sqlSource = this.sqlManager.getDbStyle().genUpdateAll(this.clazz);
        return this.handlerUpdateSql(t, sqlSource);
    }

    private int handlerUpdateSql(Object t, SQLSource sqlSource) {
        if (this.sql == null || this.sql.length() == 0) {
            throw new BeetlSQLException(20, "update\u64cd\u4f5c\u6ca1\u6709\u8f93\u5165\u8fc7\u6ee4\u6761\u4ef6\u4f1a\u5bfc\u81f4\u66f4\u65b0\u6240\u6709\u8bb0\u5f55");
        }
        GroupTemplate gt = this.sqlManager.getBeetl().getGroupTemplate();
        Template template = gt.getTemplate(sqlSource.getTemplate(), (ResourceLoader)this.tempLoader);
        template.binding("_paras", new ArrayList());
        template.binding("_root", t);
        String sql = template.render();
        List param = (List)template.getCtx().getGlobal("_paras");
        ArrayList<Object> paraLis = new ArrayList<Object>();
        for (SQLParameter sqlParameter : param) {
            paraLis.add(sqlParameter.value);
        }
        this.addPreParam(paraLis);
        StringBuilder sb = new StringBuilder(sql);
        sb.append(" ").append((CharSequence)this.getSql());
        this.setSql(sb);
        String targetSql = this.getSql().toString();
        Object[] paras = this.getParams().toArray();
        this.clear();
        int row = this.sqlManager.executeUpdate(new SQLReady(targetSql, paras));
        return row;
    }

    @Override
    public int insert(T t) {
        int ret = this.sqlManager.insert(t, true);
        return ret;
    }

    @Override
    public int insertSelective(T t) {
        return this.sqlManager.insertTemplate(t, true);
    }

    @Override
    public int delete() {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        sb.append(this.getTableName(this.clazz)).append(" ").append((CharSequence)this.getSql());
        this.setSql(sb);
        String targetSql = this.getSql().toString();
        Object[] paras = this.getParams().toArray();
        this.clear();
        int row = this.sqlManager.executeUpdate(new SQLReady(targetSql, paras));
        return row;
    }

    @Override
    public long count() {
        StringBuilder sb = new StringBuilder("SELECT COUNT(1) FROM ");
        sb.append(this.getTableName(this.clazz)).append(" ").append((CharSequence)this.getSql());
        this.setSql(sb);
        String targetSql = this.getSql().toString();
        Object[] paras = this.getParams().toArray();
        this.clear();
        List<Long> results = this.sqlManager.execute(new SQLReady(targetSql, paras), Long.class);
        return results.get(0);
    }

    @Override
    public Query<T> having(QueryCondition condition) {
        int i = condition.getSql().indexOf("WHERE");
        if (i > -1) {
            condition.getSql().delete(i, i + 5);
        }
        if (this.groupBy == null) {
            throw new BeetlSQLException(21, this.getSqlErrorTip("haveing \u9700\u8981\u5728groupBy\u540e\u8c03\u7528"));
        }
        this.groupBy.addHaving(condition.getSql().toString());
        this.addParam(condition.getParams());
        return this;
    }

    @Override
    public Query<T> groupBy(String column) {
        GroupBy groupBy = this.getGroupBy();
        groupBy.add(this.getCol(column));
        return this;
    }

    @Override
    public Query<T> orderBy(String orderBy) {
        OrderBy orderByInfo = this.getOrderBy();
        orderByInfo.add(orderBy);
        return this;
    }

    @Override
    public Query<T> asc(String column) {
        OrderBy orderByInfo = this.getOrderBy();
        this.orderBy.add(this.getCol(column) + " ASC");
        return this;
    }

    @Override
    public Query<T> desc(String column) {
        OrderBy orderByInfo = this.getOrderBy();
        this.orderBy.add(column + " DESC");
        return this;
    }

    private OrderBy getOrderBy() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy();
        }
        return this.orderBy;
    }

    private GroupBy getGroupBy() {
        if (this.groupBy == null) {
            this.groupBy = new GroupBy();
        }
        return this.groupBy;
    }

    @Override
    public Query<T> limit(long startRow, long pageSize) {
        this.startRow = startRow;
        this.pageSize = pageSize;
        return this;
    }

    private String getSqlErrorTip(String couse) {
        return String.format("\n\u250f\u2501\u2501\u2501\u2501\u2501 SQL\u8bed\u6cd5\u9519\u8bef:\n\u2523SQL\uff1a%s\n\u2523\u539f\u56e0\uff1a%s\n\u2523\u89e3\u51b3\u529e\u6cd5\uff1a\u60a8\u53ef\u80fd\u9700\u8981\u91cd\u65b0\u83b7\u53d6\u4e00\u4e2aQuery\n\u2517\u2501\u2501\u2501\u2501\u2501\n", this.getSql().toString(), couse);
    }
}

