/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine;

import java.io.Reader;
import java.io.StringReader;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.engine.StringSqlTemplateLoader;

public class SqlTemplateResource
extends Resource {
    SQLSource source;

    public SqlTemplateResource(String id, SQLSource source, ResourceLoader loader) {
        super(id, loader);
        this.source = source;
    }

    public Reader openReader() {
        return new StringReader(this.source.getTemplate());
    }

    public boolean isModified() {
        StringSqlTemplateLoader l = (StringSqlTemplateLoader)this.resourceLoader;
        SQLLoader loader = l.getSqlLLoader();
        SQLSource newSource = loader.getSQL(this.source.getId());
        if (newSource == null) {
            return true;
        }
        return this.source.getVersion().isModified(newSource.getVersion());
    }

    public String getTemplate() {
        return this.source.getTemplate();
    }

    public int getLine() {
        return this.source.getLine();
    }
}

