/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.beetl.core.Function;
import org.beetl.core.tag.TagFactory;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.DefaultNameConversion;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;
import org.springframework.core.io.Resource;

public class SpringBeetlSql {
    protected Resource configFileResource = null;
    protected String defaultSchema = null;
    ConnectionSource cs;
    DBStyle dbStyle;
    SQLLoader sqlLoader;
    NameConversion nc;
    Interceptor[] interceptors;
    SQLManager sqlManager;
    private Map<String, Function> functions = Collections.emptyMap();
    private Map<String, TagFactory> tagFactorys = Collections.emptyMap();

    @PostConstruct
    public void init() {
        if (this.dbStyle == null) {
            this.dbStyle = new MySqlStyle();
        }
        if (this.sqlLoader == null) {
            this.sqlLoader = new ClasspathLoader("/sql");
        }
        if (this.nc == null) {
            this.nc = new DefaultNameConversion();
        }
        if (this.interceptors == null) {
            this.interceptors = new Interceptor[0];
        }
        Properties properties = new Properties();
        if (this.configFileResource != null && this.configFileResource != null) {
            InputStream in = null;
            try {
                in = this.configFileResource.getInputStream();
                properties.load(in);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    in = null;
                }
            }
        }
        this.sqlManager = new SQLManager(this.dbStyle, this.sqlLoader, this.cs, this.nc, this.interceptors, this.defaultSchema, properties);
        for (Map.Entry<String, Function> entry : this.functions.entrySet()) {
            this.sqlManager.getBeetl().getGroupTemplate().registerFunction(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Function> entry : this.tagFactorys.entrySet()) {
            this.sqlManager.getBeetl().getGroupTemplate().registerTagFactory(entry.getKey(), (TagFactory)entry.getValue());
        }
    }

    public ConnectionSource getCs() {
        return this.cs;
    }

    public void setCs(ConnectionSource cs) {
        this.cs = cs;
    }

    public DBStyle getDbStyle() {
        return this.dbStyle;
    }

    public void setDbStyle(DBStyle dbStyle) {
        this.dbStyle = dbStyle;
    }

    public SQLLoader getSqlLoader() {
        return this.sqlLoader;
    }

    public void setSqlLoader(SQLLoader sqlLoader) {
        this.sqlLoader = sqlLoader;
    }

    public NameConversion getNc() {
        return this.nc;
    }

    public void setNc(NameConversion nc) {
        this.nc = nc;
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public SQLManager getSQLManager() {
        return this.sqlManager;
    }

    @Deprecated
    public SQLManager getSQLMananger() {
        return this.sqlManager;
    }

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Map<String, Function> functions) {
        this.functions = functions;
    }

    public Map<String, TagFactory> getTagFactorys() {
        return this.tagFactorys;
    }

    public void setTagFactorys(Map<String, TagFactory> tagFactorys) {
        this.tagFactorys = tagFactorys;
    }

    public Resource getConfigFileResource() {
        return this.configFileResource;
    }

    public void setConfigFileResource(Resource configFileResource) {
        this.configFileResource = configFileResource;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }
}

