/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum Encoding {
    UTF_8("utf-8", true),
    WINDOWS_1252("windows-1252", false);

    private static final Map<String, Encoding> sMap;
    final String value;
    final boolean supportsByteOrderMark;

    private Encoding(String value, boolean supportsByteOrderMark) {
        this.value = value;
        this.supportsByteOrderMark = supportsByteOrderMark;
    }

    public static Encoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return sMap.get(value.toLowerCase(Locale.US));
    }

    public String getValue() {
        return this.value;
    }

    static {
        sMap = new HashMap<String, Encoding>();
        for (Encoding mediaType : Encoding.values()) {
            sMap.put(mediaType.value, mediaType);
        }
    }
}

