/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Encoding;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum Extension {
    M3U("m3u", Encoding.WINDOWS_1252),
    M3U8("m3u8", Encoding.UTF_8);

    private static final Map<String, Extension> sMap;
    final String value;
    final Encoding encoding;

    private Extension(String value, Encoding encoding) {
        this.value = value;
        this.encoding = encoding;
    }

    public static Extension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return sMap.get(value.toLowerCase(Locale.US));
    }

    public String getValue() {
        return this.value;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    static {
        sMap = new HashMap<String, Extension>();
        for (Extension mediaType : Extension.values()) {
            sMap.put(mediaType.value, mediaType);
        }
    }
}

