/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.BaseM3uParser;
import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseState;
import com.iheartradio.m3u8.PlaylistException;
import com.iheartradio.m3u8.PlaylistValidation;
import com.iheartradio.m3u8.TrackLineParser;
import com.iheartradio.m3u8.data.MediaPlaylist;
import com.iheartradio.m3u8.data.Playlist;
import java.io.IOException;
import java.io.InputStream;

class M3uParser
extends BaseM3uParser {
    M3uParser(InputStream inputStream, Encoding encoding) {
        super(inputStream, encoding);
    }

    @Override
    public Playlist parse() throws IOException, ParseException, PlaylistException {
        this.validateAvailable();
        ParseState state = new ParseState(this.mEncoding);
        TrackLineParser trackLineParser = new TrackLineParser();
        try {
            state.setMedia();
            while (this.mScanner.hasNext()) {
                String line = this.mScanner.next();
                this.validateLine(line);
                if (line.length() == 0 || this.isComment(line)) continue;
                trackLineParser.parse(line, state);
            }
            Playlist playlist = new Playlist.Builder().withMediaPlaylist(new MediaPlaylist.Builder().withTracks(state.getMedia().tracks).build()).build();
            PlaylistValidation validation = PlaylistValidation.from(playlist);
            if (validation.isValid()) {
                return playlist;
            }
            throw new PlaylistException(this.mScanner.getInput(), validation.getErrors());
        }
        catch (ParseException exception) {
            exception.setInput(this.mScanner.getInput());
            throw exception;
        }
    }

    private void validateLine(String line) throws ParseException {
        if (!this.isComment(line) && line.length() != line.trim().length()) {
            throw ParseException.create(ParseExceptionType.WHITESPACE_IN_TRACK, line, "" + line.length());
        }
    }

    private boolean isComment(String line) {
        return line.indexOf("#") == 0;
    }
}

