/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.IParseState;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.data.EncryptionData;
import com.iheartradio.m3u8.data.MediaPlaylist;
import com.iheartradio.m3u8.data.PlaylistType;
import com.iheartradio.m3u8.data.StartData;
import com.iheartradio.m3u8.data.TrackData;
import com.iheartradio.m3u8.data.TrackInfo;
import java.util.ArrayList;
import java.util.List;

class MediaParseState
implements IParseState<MediaPlaylist> {
    public final List<TrackData> tracks = new ArrayList<TrackData>();
    public final List<String> unknownTags = new ArrayList<String>();
    public Integer targetDuration;
    public Integer mediaSequenceNumber;
    public Boolean isIframesOnly;
    public PlaylistType playlistType;
    public TrackInfo trackInfo;
    public EncryptionData encryptionData;
    public StartData startData;
    public String programDateTime;
    public boolean endOfList;
    public boolean hasDiscontinuity;

    MediaParseState() {
    }

    @Override
    public MediaPlaylist buildPlaylist() throws ParseException {
        return new MediaPlaylist.Builder().withTracks(this.tracks).withUnknownTags(this.unknownTags).withTargetDuration(this.targetDuration == null ? MediaParseState.maximumDuration(this.tracks, 0.0f) : this.targetDuration).withIsIframesOnly(this.isIframesOnly != null).withIsOngoing(!this.endOfList).withStartData(this.startData).withMediaSequenceNumber(this.mediaSequenceNumber == null ? 0 : this.mediaSequenceNumber).withPlaylistType(this.playlistType).build();
    }

    private static int maximumDuration(List<TrackData> tracks, float minValue) {
        float max = minValue;
        for (TrackData trackData : tracks) {
            if (!trackData.hasTrackInfo()) continue;
            max = Math.max(max, trackData.getTrackInfo().duration);
        }
        return 0;
    }
}

