/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Attribute;
import com.iheartradio.m3u8.AttributeParser;
import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.ExtLineParser;
import com.iheartradio.m3u8.IExtTagParser;
import com.iheartradio.m3u8.LineParser;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseState;
import com.iheartradio.m3u8.ParseUtil;
import com.iheartradio.m3u8.data.EncryptionData;
import com.iheartradio.m3u8.data.EncryptionMethod;
import com.iheartradio.m3u8.data.PlaylistType;
import com.iheartradio.m3u8.data.StartData;
import com.iheartradio.m3u8.data.TrackInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

class MediaPlaylistLineParser
implements LineParser {
    private final IExtTagParser tagParser;
    private final LineParser lineParser;
    static final IExtTagParser EXT_X_ENDLIST = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);

        @Override
        public String getTag() {
            return "EXT-X-ENDLIST";
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
            ParseUtil.match(Constants.EXT_X_ENDLIST_PATTERN, line, this.getTag());
            state.getMedia().endOfList = true;
        }
    };
    static final IExtTagParser EXT_X_I_FRAMES_ONLY = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);

        @Override
        public String getTag() {
            return "EXT-X-I-FRAMES-ONLY";
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
            ParseUtil.match(Constants.EXT_X_I_FRAMES_ONLY_PATTERN, line, this.getTag());
            if (state.getCompatibilityVersion() < 4) {
                throw ParseException.create(ParseExceptionType.REQUIRES_PROTOCOL_VERSION_4_OR_HIGHER, this.getTag());
            }
            state.setIsIframesOnly();
        }
    };
    static final IExtTagParser EXT_X_PLAYLIST_TYPE = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);

        @Override
        public String getTag() {
            return "EXT-X-PLAYLIST-TYPE";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
            Matcher matcher = ParseUtil.match(Constants.EXT_X_PLAYLIST_TYPE_PATTERN, line, this.getTag());
            if (state.getMedia().playlistType != null) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            state.getMedia().playlistType = ParseUtil.parseEnum(matcher.group(1), PlaylistType.class, this.getTag());
        }
    };
    static final IExtTagParser EXT_X_PROGRAM_DATE_TIME = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);

        @Override
        public String getTag() {
            return "EXT-X-PROGRAM-DATE-TIME";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
            Matcher matcher = ParseUtil.match(Constants.EXT_X_PROGRAM_DATE_TIME_PATTERN, line, this.getTag());
            if (state.getMedia().programDateTime != null) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            state.getMedia().programDateTime = ParseUtil.parseDateTime(line, this.getTag());
        }
    };
    static final IExtTagParser EXT_X_START = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);
        private final Map<String, AttributeParser<StartData.Builder>> HANDLERS = new HashMap<String, AttributeParser<StartData.Builder>>();
        {
            this.HANDLERS.put("TIME-OFFSET", new AttributeParser<StartData.Builder>(){

                @Override
                public void parse(Attribute attribute, StartData.Builder builder, ParseState state) throws ParseException {
                    builder.withTimeOffset(ParseUtil.parseFloat(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("PRECISE", new AttributeParser<StartData.Builder>(){

                @Override
                public void parse(Attribute attribute, StartData.Builder builder, ParseState state) throws ParseException {
                    builder.withPrecise(ParseUtil.parseYesNo(attribute, this.getTag()));
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-START";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            StartData startData;
            this.lineParser.parse(line, state);
            StartData.Builder builder = new StartData.Builder();
            ParseUtil.parseAttributes(line, builder, state, this.HANDLERS, this.getTag());
            state.getMedia().startData = startData = builder.build();
        }
    };
    static final IExtTagParser EXT_X_TARGETDURATION = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);

        @Override
        public String getTag() {
            return "EXT-X-TARGETDURATION";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
            Matcher matcher = ParseUtil.match(Constants.EXT_X_TARGETDURATION_PATTERN, line, this.getTag());
            if (state.getMedia().targetDuration != null) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            state.getMedia().targetDuration = ParseUtil.parseInt(matcher.group(1), this.getTag());
        }
    };
    static final IExtTagParser EXT_X_MEDIA_SEQUENCE = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);

        @Override
        public String getTag() {
            return "EXT-X-MEDIA-SEQUENCE";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
            Matcher matcher = ParseUtil.match(Constants.EXT_X_MEDIA_SEQUENCE_PATTERN, line, this.getTag());
            if (state.getMedia().mediaSequenceNumber != null) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            state.getMedia().mediaSequenceNumber = ParseUtil.parseInt(matcher.group(1), this.getTag());
        }
    };
    static final IExtTagParser EXT_X_ALLOW_CACHE = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);

        @Override
        public String getTag() {
            return "EXT-X-ALLOW-CACHE";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
        }
    };
    static final IExtTagParser EXTINF = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);

        @Override
        public String getTag() {
            return "EXTINF";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
            Matcher matcher = ParseUtil.match(Constants.EXTINF_PATTERN, line, this.getTag());
            state.getMedia().trackInfo = new TrackInfo(ParseUtil.parseFloat(matcher.group(1), this.getTag()), matcher.group(2));
        }
    };
    static final IExtTagParser EXT_X_DISCONTINUITY = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);

        @Override
        public String getTag() {
            return "EXT-X-DISCONTINUITY";
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
            Matcher matcher = ParseUtil.match(Constants.EXT_X_DISCONTINUITY_PATTERN, line, this.getTag());
            state.getMedia().hasDiscontinuity = true;
        }
    };
    static final IExtTagParser EXT_X_KEY = new IExtTagParser(){
        private final LineParser lineParser = new MediaPlaylistLineParser(this);
        private final Map<String, AttributeParser<EncryptionData.Builder>> HANDLERS = new HashMap<String, AttributeParser<EncryptionData.Builder>>();
        {
            this.HANDLERS.put("METHOD", new AttributeParser<EncryptionData.Builder>(){

                @Override
                public void parse(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    EncryptionMethod method = EncryptionMethod.fromValue(attribute.value);
                    if (method == null) {
                        throw ParseException.create(ParseExceptionType.INVALID_ENCRYPTION_METHOD, this.getTag(), attribute.toString());
                    }
                    builder.withMethod(method);
                }
            });
            this.HANDLERS.put("URI", new AttributeParser<EncryptionData.Builder>(){

                @Override
                public void parse(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    builder.withUri(ParseUtil.decodeUri(ParseUtil.parseQuotedString(attribute.value, this.getTag()), state.encoding));
                }
            });
            this.HANDLERS.put("IV", new AttributeParser<EncryptionData.Builder>(){

                @Override
                public void parse(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    List<Byte> initializationVector = ParseUtil.parseHexadecimal(attribute.value, this.getTag());
                    if (initializationVector.size() != 16 && initializationVector.size() != 32) {
                        throw ParseException.create(ParseExceptionType.INVALID_IV_SIZE, this.getTag(), attribute.toString());
                    }
                    builder.withInitializationVector(initializationVector);
                }
            });
            this.HANDLERS.put("KEYFORMAT", new AttributeParser<EncryptionData.Builder>(){

                @Override
                public void parse(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    builder.withKeyFormat(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("KEYFORMATVERSIONS", new AttributeParser<EncryptionData.Builder>(){

                @Override
                public void parse(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    String[] versionStrings = ParseUtil.parseQuotedString(attribute.value, this.getTag()).split("/");
                    ArrayList<Integer> versions = new ArrayList<Integer>();
                    for (String version : versionStrings) {
                        try {
                            versions.add(Integer.parseInt(version));
                        }
                        catch (NumberFormatException exception) {
                            throw ParseException.create(ParseExceptionType.INVALID_KEY_FORMAT_VERSIONS, this.getTag(), attribute.toString());
                        }
                    }
                    builder.withKeyFormatVersions(versions);
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-KEY";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.lineParser.parse(line, state);
            EncryptionData.Builder builder = new EncryptionData.Builder().withKeyFormat("identity").withKeyFormatVersions(Constants.DEFAULT_KEY_FORMAT_VERSIONS);
            ParseUtil.parseAttributes(line, builder, state, this.HANDLERS, this.getTag());
            EncryptionData encryptionData = builder.build();
            if (encryptionData.getMethod() != EncryptionMethod.NONE && encryptionData.getUri() == null) {
                throw ParseException.create(ParseExceptionType.MISSING_ENCRYPTION_URI, this.getTag(), line);
            }
            state.getMedia().encryptionData = encryptionData;
        }
    };

    MediaPlaylistLineParser(IExtTagParser parser) {
        this(parser, new ExtLineParser(parser));
    }

    MediaPlaylistLineParser(IExtTagParser tagParser, LineParser lineParser) {
        this.tagParser = tagParser;
        this.lineParser = lineParser;
    }

    @Override
    public void parse(String line, ParseState state) throws ParseException {
        if (state.isMaster()) {
            throw ParseException.create(ParseExceptionType.MEDIA_IN_MASTER, this.tagParser.getTag());
        }
        state.setMedia();
        this.lineParser.parse(line, state);
    }
}

