/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.AttributeWriter;
import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.ExtTagWriter;
import com.iheartradio.m3u8.IExtTagWriter;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.TagWriter;
import com.iheartradio.m3u8.WriteUtil;
import com.iheartradio.m3u8.data.EncryptionData;
import com.iheartradio.m3u8.data.MediaPlaylist;
import com.iheartradio.m3u8.data.Playlist;
import com.iheartradio.m3u8.data.StartData;
import com.iheartradio.m3u8.data.TrackData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

abstract class MediaPlaylistTagWriter
extends ExtTagWriter {
    static final IExtTagWriter EXT_X_ENDLIST = new MediaPlaylistTagWriter(){

        @Override
        public String getTag() {
            return "EXT-X-ENDLIST";
        }

        @Override
        boolean hasData() {
            return false;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) throws IOException {
            if (!mediaPlaylist.isOngoing()) {
                tagWriter.writeTag(this.getTag());
            }
        }
    };
    static final IExtTagWriter EXT_X_I_FRAMES_ONLY = new MediaPlaylistTagWriter(){

        @Override
        public String getTag() {
            return "EXT-X-I-FRAMES-ONLY";
        }

        @Override
        boolean hasData() {
            return false;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) throws IOException {
            if (mediaPlaylist.isIframesOnly()) {
                tagWriter.writeTag(this.getTag());
            }
        }
    };
    static final IExtTagWriter EXT_X_PLAYLIST_TYPE = new MediaPlaylistTagWriter(){

        @Override
        public String getTag() {
            return "EXT-X-PLAYLIST-TYPE";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) throws IOException {
            if (mediaPlaylist.getPlaylistType() != null) {
                tagWriter.writeTag(this.getTag(), mediaPlaylist.getPlaylistType().getValue());
            }
        }
    };
    static final IExtTagWriter EXT_X_START = new MediaPlaylistTagWriter(){
        private final Map<String, AttributeWriter<StartData>> HANDLERS = new HashMap<String, AttributeWriter<StartData>>();
        {
            this.HANDLERS.put("TIME-OFFSET", new AttributeWriter<StartData>(){

                @Override
                public boolean containsAttribute(StartData attributes) {
                    return true;
                }

                @Override
                public String write(StartData attributes) throws ParseException {
                    return Float.toString(attributes.getTimeOffset());
                }
            });
            this.HANDLERS.put("PRECISE", new AttributeWriter<StartData>(){

                @Override
                public boolean containsAttribute(StartData attributes) {
                    return true;
                }

                @Override
                public String write(StartData attributes) throws ParseException {
                    if (attributes.isPrecise()) {
                        return "YES";
                    }
                    return "NO";
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-START";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) throws IOException, ParseException {
            if (mediaPlaylist.hasStartData()) {
                StartData startData = mediaPlaylist.getStartData();
                this.writeAttributes(tagWriter, startData, this.HANDLERS);
            }
        }
    };
    static final IExtTagWriter EXT_X_TARGETDURATION = new MediaPlaylistTagWriter(){

        @Override
        public String getTag() {
            return "EXT-X-TARGETDURATION";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) throws IOException, ParseException {
            tagWriter.writeTag(this.getTag(), Integer.toString(mediaPlaylist.getTargetDuration()));
        }
    };
    static final IExtTagWriter EXT_X_MEDIA_SEQUENCE = new MediaPlaylistTagWriter(){

        @Override
        public String getTag() {
            return "EXT-X-MEDIA-SEQUENCE";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) throws IOException, ParseException {
            tagWriter.writeTag(this.getTag(), Integer.toString(mediaPlaylist.getMediaSequenceNumber()));
        }
    };
    static final IExtTagWriter EXT_X_ALLOW_CACHE = new MediaPlaylistTagWriter(){

        @Override
        public String getTag() {
            return "EXT-X-ALLOW-CACHE";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) {
        }
    };
    static final IExtTagWriter EXTINF = new MediaPlaylistTagWriter(){

        @Override
        public String getTag() {
            return "EXTINF";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) throws IOException, ParseException {
            for (TrackData trackData : mediaPlaylist.getTracks()) {
                StringBuilder sb = new StringBuilder();
                if (playlist.getCompatibilityVersion() <= 3) {
                    sb.append(Integer.toString((int)trackData.getTrackInfo().duration));
                } else {
                    sb.append(Float.toString(trackData.getTrackInfo().duration));
                }
                if (trackData.getTrackInfo().title != null) {
                    sb.append(Constants.COMMA).append(trackData.getTrackInfo().title);
                }
                if (trackData.hasDiscontinuity()) {
                    tagWriter.writeTag("EXT-X-DISCONTINUITY");
                }
                tagWriter.writeTag(this.getTag(), sb.toString());
                tagWriter.writeLine(trackData.getUri());
            }
        }
    };
    static final ExtTagWriter EXT_X_KEY = new MediaPlaylistTagWriter(){
        private final Map<String, AttributeWriter<EncryptionData>> HANDLERS = new HashMap<String, AttributeWriter<EncryptionData>>();
        {
            this.HANDLERS.put("METHOD", new AttributeWriter<EncryptionData>(){

                @Override
                public boolean containsAttribute(EncryptionData attributes) {
                    return true;
                }

                @Override
                public String write(EncryptionData encryptionData) {
                    return encryptionData.getMethod().getValue();
                }
            });
            this.HANDLERS.put("URI", new AttributeWriter<EncryptionData>(){

                @Override
                public boolean containsAttribute(EncryptionData attributes) {
                    return true;
                }

                @Override
                public String write(EncryptionData encryptionData) throws ParseException {
                    return WriteUtil.writeQuotedString(encryptionData.getUri(), this.getTag());
                }
            });
            this.HANDLERS.put("IV", new AttributeWriter<EncryptionData>(){

                @Override
                public boolean containsAttribute(EncryptionData attribute) {
                    return attribute.hasInitializationVector();
                }

                @Override
                public String write(EncryptionData encryptionData) {
                    return WriteUtil.writeHexadecimal(encryptionData.getInitializationVector());
                }
            });
            this.HANDLERS.put("KEYFORMAT", new AttributeWriter<EncryptionData>(){

                @Override
                public boolean containsAttribute(EncryptionData attributes) {
                    return true;
                }

                @Override
                public String write(EncryptionData encryptionData) throws ParseException {
                    return WriteUtil.writeQuotedString(encryptionData.getKeyFormat(), this.getTag());
                }
            });
            this.HANDLERS.put("KEYFORMATVERSIONS", new AttributeWriter<EncryptionData>(){

                @Override
                public boolean containsAttribute(EncryptionData attributes) {
                    return true;
                }

                @Override
                public String write(EncryptionData encryptionData) throws ParseException {
                    return WriteUtil.writeQuotedString(WriteUtil.join(encryptionData.getKeyFormatVersions(), "/"), this.getTag());
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-KEY";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) throws IOException, ParseException {
            TrackData td;
            if (mediaPlaylist.getTracks().size() > 0 && (td = mediaPlaylist.getTracks().get(0)).hasEncryptionData()) {
                EncryptionData ed = td.getEncryptionData();
                this.writeAttributes(tagWriter, ed, this.HANDLERS);
            }
        }
    };

    MediaPlaylistTagWriter() {
    }

    @Override
    public final void write(TagWriter tagWriter, Playlist playlist) throws IOException, ParseException {
        if (playlist.hasMediaPlaylist()) {
            this.doWrite(tagWriter, playlist, playlist.getMediaPlaylist());
        }
    }

    public void doWrite(TagWriter tagWriter, Playlist playlist, MediaPlaylist mediaPlaylist) throws IOException, ParseException {
        tagWriter.writeTag(this.getTag());
    }
}

