/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.IParseState;
import com.iheartradio.m3u8.MasterParseState;
import com.iheartradio.m3u8.MediaParseState;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.data.Playlist;

class ParseState
implements IParseState<Playlist> {
    static final int NONE = -1;
    public final Encoding encoding;
    private MasterParseState mMasterParseState;
    private MediaParseState mMediaParseState;
    private boolean mIsExtended;
    private boolean mIsIframesOnly;
    private int mCompatibilityVersion = -1;

    public ParseState(Encoding encoding) {
        this.encoding = encoding;
    }

    public boolean isMaster() {
        return this.mMasterParseState != null;
    }

    public MasterParseState getMaster() {
        return this.mMasterParseState;
    }

    public void setMaster() throws ParseException {
        if (this.isMedia()) {
            throw new ParseException(ParseExceptionType.MASTER_IN_MEDIA);
        }
        if (this.mMasterParseState == null) {
            this.mMasterParseState = new MasterParseState();
        }
    }

    public boolean isMedia() {
        return this.mMediaParseState != null;
    }

    public MediaParseState getMedia() {
        return this.mMediaParseState;
    }

    public void setMedia() throws ParseException {
        if (this.mMediaParseState == null) {
            this.mMediaParseState = new MediaParseState();
        }
    }

    public boolean isExtended() {
        return this.mIsExtended;
    }

    public void setExtended() {
        this.mIsExtended = true;
    }

    public boolean isIframesOnly() {
        return this.mIsIframesOnly;
    }

    public void setIsIframesOnly() throws ParseException {
        if (this.isMaster()) {
            throw new ParseException(ParseExceptionType.MEDIA_IN_MASTER);
        }
        this.getMedia().isIframesOnly = true;
    }

    public int getCompatibilityVersion() {
        return this.mCompatibilityVersion;
    }

    public void setCompatibilityVersion(int compatibilityVersion) {
        this.mCompatibilityVersion = compatibilityVersion;
    }

    @Override
    public Playlist buildPlaylist() throws ParseException {
        Playlist.Builder playlistBuilder = new Playlist.Builder();
        if (this.isMaster()) {
            playlistBuilder.withMasterPlaylist(this.mMasterParseState.buildPlaylist());
        } else if (this.isMedia()) {
            playlistBuilder.withMediaPlaylist(this.mMediaParseState.buildPlaylist()).withExtended(this.mIsExtended);
        } else {
            throw new ParseException(ParseExceptionType.UNKNOWN_PLAYLIST_TYPE);
        }
        return playlistBuilder.withCompatibilityVersion(this.mCompatibilityVersion == -1 ? 1 : this.mCompatibilityVersion).build();
    }
}

