/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ExtendedM3uParser;
import com.iheartradio.m3u8.Extension;
import com.iheartradio.m3u8.Format;
import com.iheartradio.m3u8.IPlaylistParser;
import com.iheartradio.m3u8.M3uParser;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParsingMode;
import com.iheartradio.m3u8.PlaylistException;
import com.iheartradio.m3u8.data.Playlist;
import java.io.IOException;
import java.io.InputStream;

public class PlaylistParser
implements IPlaylistParser {
    private final IPlaylistParser mPlaylistParser;

    public PlaylistParser(InputStream inputStream, Format format, String filename) {
        this(inputStream, format, PlaylistParser.parseExtension(filename), ParsingMode.STRICT);
    }

    public PlaylistParser(InputStream inputStream, Format format, String filename, ParsingMode parsingMode) {
        this(inputStream, format, PlaylistParser.parseExtension(filename), parsingMode);
    }

    public PlaylistParser(InputStream inputStream, Format format, Extension extension) {
        this(inputStream, format, extension.encoding, ParsingMode.STRICT);
    }

    public PlaylistParser(InputStream inputStream, Format format, Extension extension, ParsingMode parsingMode) {
        this(inputStream, format, extension.encoding, parsingMode);
    }

    public PlaylistParser(InputStream inputStream, Format format, Encoding encoding) {
        this(inputStream, format, encoding, ParsingMode.STRICT);
    }

    public PlaylistParser(InputStream inputStream, Format format, Encoding encoding, ParsingMode parsingMode) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        if (parsingMode == null && format != Format.M3U) {
            throw new IllegalArgumentException("parsingMode is null");
        }
        switch (format) {
            case M3U: {
                this.mPlaylistParser = new M3uParser(inputStream, encoding);
                break;
            }
            case EXT_M3U: {
                this.mPlaylistParser = new ExtendedM3uParser(inputStream, encoding, parsingMode);
                break;
            }
            default: {
                throw new RuntimeException("unsupported format detected, this should be impossible: " + (Object)((Object)format));
            }
        }
    }

    @Override
    public Playlist parse() throws IOException, ParseException, PlaylistException {
        return this.mPlaylistParser.parse();
    }

    @Override
    public boolean isAvailable() {
        return this.mPlaylistParser.isAvailable();
    }

    private static Extension parseExtension(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalArgumentException("filename has no extension: " + filename);
        }
        String extension = filename.substring(index + 1);
        if (Extension.M3U.value.equalsIgnoreCase(extension)) {
            return Extension.M3U;
        }
        if (Extension.M3U8.value.equalsIgnoreCase(extension)) {
            return Extension.M3U8;
        }
        throw new IllegalArgumentException("filename extension should be .m3u or .m3u8: " + filename);
    }
}

