/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.ParsingMode;
import com.iheartradio.m3u8.PlaylistError;
import com.iheartradio.m3u8.data.IFrameStreamInfo;
import com.iheartradio.m3u8.data.MasterPlaylist;
import com.iheartradio.m3u8.data.MediaData;
import com.iheartradio.m3u8.data.MediaPlaylist;
import com.iheartradio.m3u8.data.MediaType;
import com.iheartradio.m3u8.data.Playlist;
import com.iheartradio.m3u8.data.PlaylistData;
import com.iheartradio.m3u8.data.StartData;
import com.iheartradio.m3u8.data.TrackData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PlaylistValidation {
    private final Set<PlaylistError> mErrors;

    private PlaylistValidation(Set<PlaylistError> errors) {
        this.mErrors = Collections.unmodifiableSet(errors);
    }

    public String toString() {
        return "(PlaylistValidation" + " valid=" + this.isValid() + " errors=" + this.mErrors + ")";
    }

    public boolean isValid() {
        return this.mErrors.isEmpty();
    }

    public Set<PlaylistError> getErrors() {
        return this.mErrors;
    }

    public static PlaylistValidation from(Playlist playlist) {
        return PlaylistValidation.from(playlist, ParsingMode.STRICT);
    }

    public static PlaylistValidation from(Playlist playlist, ParsingMode parsingMode) {
        HashSet<PlaylistError> errors = new HashSet<PlaylistError>();
        if (playlist == null) {
            errors.add(PlaylistError.NO_PLAYLIST);
            return new PlaylistValidation(errors);
        }
        if (playlist.getCompatibilityVersion() < 1) {
            errors.add(PlaylistError.COMPATIBILITY_TOO_LOW);
        }
        if (PlaylistValidation.hasNoPlaylistTypes(playlist)) {
            errors.add(PlaylistError.NO_MASTER_OR_MEDIA);
        } else if (PlaylistValidation.hasBothPlaylistTypes(playlist)) {
            errors.add(PlaylistError.BOTH_MASTER_AND_MEDIA);
        }
        if (playlist.hasMasterPlaylist()) {
            if (!playlist.isExtended()) {
                errors.add(PlaylistError.MASTER_NOT_EXTENDED);
            }
            PlaylistValidation.addMasterPlaylistErrors(playlist.getMasterPlaylist(), errors);
        }
        if (playlist.hasMediaPlaylist()) {
            PlaylistValidation.addMediaPlaylistErrors(playlist.getMediaPlaylist(), errors, playlist.isExtended(), parsingMode);
        }
        return new PlaylistValidation(errors);
    }

    private static boolean hasNoPlaylistTypes(Playlist playlist) {
        return !playlist.hasMasterPlaylist() && !playlist.hasMediaPlaylist();
    }

    private static boolean hasBothPlaylistTypes(Playlist playlist) {
        return playlist.hasMasterPlaylist() && playlist.hasMediaPlaylist();
    }

    private static void addMasterPlaylistErrors(MasterPlaylist playlist, Set<PlaylistError> errors) {
        for (PlaylistData playlistData : playlist.getPlaylists()) {
            PlaylistValidation.addPlaylistDataErrors(playlistData, errors);
        }
        for (IFrameStreamInfo iFrameStreamInfo : playlist.getIFramePlaylists()) {
            PlaylistValidation.addIFrameStreamInfoErrors(iFrameStreamInfo, errors);
        }
        for (MediaData mediaData : playlist.getMediaData()) {
            PlaylistValidation.addMediaDataErrors(mediaData, errors);
        }
    }

    private static void addMediaPlaylistErrors(MediaPlaylist playlist, Set<PlaylistError> errors, boolean isExtended, ParsingMode parsingMode) {
        if (isExtended && playlist.hasStartData()) {
            PlaylistValidation.addStartErrors(playlist.getStartData(), errors);
        }
        for (TrackData trackData : playlist.getTracks()) {
            PlaylistValidation.addTrackDataErrors(trackData, errors, isExtended, parsingMode);
        }
    }

    private static void addStartErrors(StartData startData, Set<PlaylistError> errors) {
        if (Float.isNaN(startData.getTimeOffset())) {
            errors.add(PlaylistError.START_DATA_WITHOUT_TIME_OFFSET);
        }
    }

    private static void addPlaylistDataErrors(PlaylistData playlistData, Set<PlaylistError> errors) {
        if (playlistData.getUri() == null || playlistData.getUri().isEmpty()) {
            errors.add(PlaylistError.PLAYLIST_DATA_WITHOUT_URI);
        }
        if (playlistData.hasStreamInfo()) {
            if (playlistData.getStreamInfo().getBandwidth() == -1) {
                errors.add(PlaylistError.STREAM_INFO_WITH_NO_BANDWIDTH);
            }
            if (playlistData.getStreamInfo().getAverageBandwidth() < -1) {
                errors.add(PlaylistError.STREAM_INFO_WITH_INVALID_AVERAGE_BANDWIDTH);
            }
        }
    }

    private static void addIFrameStreamInfoErrors(IFrameStreamInfo streamInfo, Set<PlaylistError> errors) {
        if (streamInfo.getUri() == null || streamInfo.getUri().isEmpty()) {
            errors.add(PlaylistError.I_FRAME_STREAM_WITHOUT_URI);
        }
        if (streamInfo.getBandwidth() == -1) {
            errors.add(PlaylistError.I_FRAME_STREAM_WITH_NO_BANDWIDTH);
        }
        if (streamInfo.getAverageBandwidth() < -1) {
            errors.add(PlaylistError.I_FRAME_STREAM_WITH_INVALID_AVERAGE_BANDWIDTH);
        }
    }

    private static void addMediaDataErrors(MediaData mediaData, Set<PlaylistError> errors) {
        if (mediaData.getType() == null) {
            errors.add(PlaylistError.MEDIA_DATA_WITHOUT_TYPE);
        }
        if (mediaData.getGroupId() == null) {
            errors.add(PlaylistError.MEDIA_DATA_WITHOUT_GROUP_ID);
        }
        if (mediaData.getName() == null) {
            errors.add(PlaylistError.MEDIA_DATA_WITHOUT_NAME);
        }
        if (mediaData.getType() == MediaType.CLOSED_CAPTIONS) {
            if (mediaData.hasUri()) {
                errors.add(PlaylistError.CLOSE_CAPTIONS_WITH_URI);
            }
            if (mediaData.getInStreamId() == null) {
                errors.add(PlaylistError.CLOSE_CAPTIONS_WITHOUT_IN_STREAM_ID);
            }
        } else if (mediaData.getType() != MediaType.CLOSED_CAPTIONS && mediaData.getInStreamId() != null) {
            errors.add(PlaylistError.IN_STREAM_ID_WITHOUT_CLOSE_CAPTIONS);
        }
        if (mediaData.isDefault() && !mediaData.isAutoSelect()) {
            errors.add(PlaylistError.DEFAULT_WITHOUT_AUTO_SELECT);
        }
        if (mediaData.getType() != MediaType.SUBTITLES && mediaData.isForced()) {
            errors.add(PlaylistError.FORCED_WITHOUT_SUBTITLES);
        }
    }

    private static void addTrackDataErrors(TrackData trackData, Set<PlaylistError> errors, boolean isExtended, ParsingMode parsingMode) {
        if (trackData.getUri() == null || trackData.getUri().isEmpty()) {
            errors.add(PlaylistError.TRACK_DATA_WITHOUT_URI);
        }
        if (isExtended && !trackData.hasTrackInfo()) {
            errors.add(PlaylistError.EXTENDED_TRACK_DATA_WITHOUT_TRACK_INFO);
        }
        if (trackData.hasEncryptionData() && trackData.getEncryptionData().getMethod() == null) {
            errors.add(PlaylistError.ENCRYPTION_DATA_WITHOUT_METHOD);
        }
        if (trackData.hasTrackInfo() && !parsingMode.allowNegativeNumbers && trackData.getTrackInfo().duration < 0.0f) {
            errors.add(PlaylistError.TRACK_INFO_WITH_NEGATIVE_DURATION);
        }
    }
}

