/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseUtil;
import com.iheartradio.m3u8.data.Resolution;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class WriteUtil {
    public static String writeYesNo(boolean yes) {
        if (yes) {
            return "YES";
        }
        return "NO";
    }

    public static String writeHexadecimal(List<Byte> hex) {
        if (hex == null || hex.size() == 0) {
            throw new IllegalArgumentException("hex might not be null or empty!");
        }
        String prefix = "0x";
        StringBuilder builder = new StringBuilder(hex.size() + "0x".length());
        builder.append("0x");
        for (Byte b : hex) {
            builder.append(Integer.toHexString(b.byteValue()));
        }
        return builder.toString();
    }

    public static String writeResolution(Resolution r) {
        return r.width + "x" + r.height;
    }

    public static String writeQuotedString(String unquotedString, String tag) throws ParseException {
        StringBuilder builder = new StringBuilder(unquotedString.length() + 2);
        builder.append("\"");
        for (int i = 0; i < unquotedString.length(); ++i) {
            char c = unquotedString.charAt(i);
            if (i == 0 && ParseUtil.isWhitespace(c)) {
                throw new ParseException(ParseExceptionType.ILLEGAL_WHITESPACE, tag);
            }
            if (c == '\"') {
                builder.append('\\').append(c);
                continue;
            }
            builder.append(c);
        }
        builder.append("\"");
        return builder.toString();
    }

    public static String encodeUri(String decodedUri) throws ParseException {
        try {
            return URLEncoder.encode(decodedUri.replace("%2B", "+"), "utf-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new ParseException(ParseExceptionType.INTERNAL_ERROR);
        }
    }

    public static String join(List<? extends Object> valueList, String separator) {
        if (valueList == null || valueList.size() == 0) {
            throw new IllegalArgumentException("valueList might not be null or empty!");
        }
        if (separator == null) {
            throw new IllegalArgumentException("separator might not be null!");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < valueList.size(); ++i) {
            sb.append(valueList.get(i).toString());
            if (i + 1 >= valueList.size()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

