/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import com.iheartradio.m3u8.data.StreamInfo;
import java.util.Objects;

public class PlaylistData {
    private final String mUri;
    private final StreamInfo mStreamInfo;

    private PlaylistData(String uri, StreamInfo streamInfo) {
        this.mUri = uri;
        this.mStreamInfo = streamInfo;
    }

    public String getUri() {
        return this.mUri;
    }

    public boolean hasStreamInfo() {
        return this.mStreamInfo != null;
    }

    public StreamInfo getStreamInfo() {
        return this.mStreamInfo;
    }

    public Builder buildUpon() {
        return new Builder(this.mUri, this.mStreamInfo);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mStreamInfo);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PlaylistData)) {
            return false;
        }
        PlaylistData other = (PlaylistData)o;
        return super.equals(other) && Objects.equals(this.mStreamInfo, other.mStreamInfo);
    }

    public String toString() {
        return "PlaylistData [mStreamInfo=" + this.mStreamInfo + ", mUri=" + this.mUri + "]";
    }

    public static class Builder {
        private String mUri;
        private StreamInfo mStreamInfo;

        public Builder() {
        }

        private Builder(String uri, StreamInfo streamInfo) {
            this.mUri = uri;
            this.mStreamInfo = streamInfo;
        }

        public Builder withPath(String path) {
            this.mUri = path;
            return this;
        }

        public Builder withUri(String uri) {
            this.mUri = uri;
            return this;
        }

        public Builder withStreamInfo(StreamInfo streamInfo) {
            this.mStreamInfo = streamInfo;
            return this;
        }

        public PlaylistData build() {
            return new PlaylistData(this.mUri, this.mStreamInfo);
        }
    }
}

