/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import com.iheartradio.m3u8.data.IStreamInfo;
import com.iheartradio.m3u8.data.Resolution;
import com.iheartradio.m3u8.data.StreamInfoBuilder;
import java.util.List;
import java.util.Objects;

public class StreamInfo
implements IStreamInfo {
    public static final int NO_BANDWIDTH = -1;
    private final int mBandwidth;
    private final int mAverageBandwidth;
    private final List<String> mCodecs;
    private final Resolution mResolution;
    private final float mFrameRate;
    private final String mAudio;
    private final String mVideo;
    private final String mSubtitles;
    private final String mClosedCaptions;

    private StreamInfo(int bandwidth, int averageBandwidth, List<String> codecs, Resolution resolution, float frameRate, String audio, String video, String subtitles, String closedCaptions) {
        this.mBandwidth = bandwidth;
        this.mAverageBandwidth = averageBandwidth;
        this.mCodecs = codecs;
        this.mResolution = resolution;
        this.mFrameRate = frameRate;
        this.mAudio = audio;
        this.mVideo = video;
        this.mSubtitles = subtitles;
        this.mClosedCaptions = closedCaptions;
    }

    @Override
    public int getBandwidth() {
        return this.mBandwidth;
    }

    @Override
    public boolean hasAverageBandwidth() {
        return this.mAverageBandwidth != -1;
    }

    @Override
    public int getAverageBandwidth() {
        return this.mAverageBandwidth;
    }

    @Override
    public boolean hasCodecs() {
        return this.mCodecs != null;
    }

    @Override
    public List<String> getCodecs() {
        return this.mCodecs;
    }

    @Override
    public boolean hasResolution() {
        return this.mResolution != null;
    }

    @Override
    public Resolution getResolution() {
        return this.mResolution;
    }

    @Override
    public boolean hasFrameRate() {
        return !Float.isNaN(this.mFrameRate);
    }

    @Override
    public float getFrameRate() {
        return this.mFrameRate;
    }

    public boolean hasAudio() {
        return this.mAudio != null;
    }

    public String getAudio() {
        return this.mAudio;
    }

    @Override
    public boolean hasVideo() {
        return this.mVideo != null;
    }

    @Override
    public String getVideo() {
        return this.mVideo;
    }

    public boolean hasSubtitles() {
        return this.mSubtitles != null;
    }

    public String getSubtitles() {
        return this.mSubtitles;
    }

    public boolean hasClosedCaptions() {
        return this.mClosedCaptions != null;
    }

    public String getClosedCaptions() {
        return this.mClosedCaptions;
    }

    public Builder buildUpon() {
        return new Builder(this.mBandwidth, this.mAverageBandwidth, this.mCodecs, this.mResolution, this.mFrameRate, this.mAudio, this.mVideo, this.mSubtitles, this.mClosedCaptions);
    }

    public int hashCode() {
        return Objects.hash(this.mBandwidth, this.mAverageBandwidth, this.mCodecs, this.mResolution, Float.valueOf(this.mFrameRate), this.mAudio, this.mVideo, this.mSubtitles, this.mClosedCaptions);
    }

    public boolean equals(Object o) {
        if (!(o instanceof StreamInfo)) {
            return false;
        }
        StreamInfo other = (StreamInfo)o;
        return this.mBandwidth == other.mBandwidth && this.mAverageBandwidth == other.mAverageBandwidth && Objects.equals(this.mCodecs, other.mCodecs) && Objects.equals(this.mResolution, other.mResolution) && Objects.equals(Float.valueOf(this.mFrameRate), Float.valueOf(other.mFrameRate)) && Objects.equals(this.mAudio, other.mAudio) && Objects.equals(this.mVideo, other.mVideo) && Objects.equals(this.mSubtitles, other.mSubtitles) && Objects.equals(this.mClosedCaptions, other.mClosedCaptions);
    }

    public static class Builder
    implements StreamInfoBuilder {
        private int mBandwidth = -1;
        private int mAverageBandwidth = -1;
        private List<String> mCodecs;
        private Resolution mResolution;
        private float mFrameRate = Float.NaN;
        private String mAudio;
        private String mVideo;
        private String mSubtitles;
        private String mClosedCaptions;

        public Builder() {
        }

        private Builder(int bandwidth, int averageBandwidth, List<String> codecs, Resolution resolution, float frameRate, String audio, String video, String subtitles, String closedCaptions) {
            this.mBandwidth = bandwidth;
            this.mAverageBandwidth = averageBandwidth;
            this.mCodecs = codecs;
            this.mResolution = resolution;
            this.mFrameRate = frameRate;
            this.mAudio = audio;
            this.mVideo = video;
            this.mSubtitles = subtitles;
            this.mClosedCaptions = closedCaptions;
        }

        @Override
        public Builder withBandwidth(int bandwidth) {
            this.mBandwidth = bandwidth;
            return this;
        }

        @Override
        public Builder withAverageBandwidth(int averageBandwidth) {
            this.mAverageBandwidth = averageBandwidth;
            return this;
        }

        @Override
        public Builder withCodecs(List<String> codecs) {
            this.mCodecs = codecs;
            return this;
        }

        @Override
        public Builder withResolution(Resolution resolution) {
            this.mResolution = resolution;
            return this;
        }

        @Override
        public Builder withFrameRate(float frameRate) {
            this.mFrameRate = frameRate;
            return this;
        }

        public Builder withAudio(String audio) {
            this.mAudio = audio;
            return this;
        }

        @Override
        public Builder withVideo(String video) {
            this.mVideo = video;
            return this;
        }

        public Builder withSubtitles(String subtitles) {
            this.mSubtitles = subtitles;
            return this;
        }

        public Builder withClosedCaptions(String closedCaptions) {
            this.mClosedCaptions = closedCaptions;
            return this;
        }

        public StreamInfo build() {
            return new StreamInfo(this.mBandwidth, this.mAverageBandwidth, this.mCodecs, this.mResolution, this.mFrameRate, this.mAudio, this.mVideo, this.mSubtitles, this.mClosedCaptions);
        }
    }
}

