/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import com.iheartradio.m3u8.data.EncryptionData;
import com.iheartradio.m3u8.data.EncryptionMethod;
import com.iheartradio.m3u8.data.TrackInfo;
import java.util.Objects;

public class TrackData {
    private final String mUri;
    private final TrackInfo mTrackInfo;
    private final EncryptionData mEncryptionData;
    private final String mProgramDateTime;
    private final boolean mHasDiscontinuity;

    private TrackData(String uri, TrackInfo trackInfo, EncryptionData encryptionData, String programDateTime, boolean hasDiscontinuity) {
        this.mUri = uri;
        this.mTrackInfo = trackInfo;
        this.mEncryptionData = encryptionData;
        this.mProgramDateTime = programDateTime;
        this.mHasDiscontinuity = hasDiscontinuity;
    }

    public String getUri() {
        return this.mUri;
    }

    public boolean hasTrackInfo() {
        return this.mTrackInfo != null;
    }

    public TrackInfo getTrackInfo() {
        return this.mTrackInfo;
    }

    public boolean hasEncryptionData() {
        return this.mEncryptionData != null;
    }

    public boolean isEncrypted() {
        return this.hasEncryptionData() && this.mEncryptionData.getMethod() != null && this.mEncryptionData.getMethod() != EncryptionMethod.NONE;
    }

    public boolean hasProgramDateTime() {
        return this.mProgramDateTime != null && this.mProgramDateTime.length() > 0;
    }

    public String getProgramDateTime() {
        return this.mProgramDateTime;
    }

    public boolean hasDiscontinuity() {
        return this.mHasDiscontinuity;
    }

    public EncryptionData getEncryptionData() {
        return this.mEncryptionData;
    }

    public Builder buildUpon() {
        return new Builder(this.getUri(), this.mTrackInfo, this.mEncryptionData, this.mHasDiscontinuity);
    }

    public int hashCode() {
        return Objects.hash(this.mUri, this.mEncryptionData, this.mTrackInfo, this.mHasDiscontinuity);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TrackData)) {
            return false;
        }
        TrackData other = (TrackData)o;
        return Objects.equals(this.mUri, other.mUri) && Objects.equals(this.mTrackInfo, other.mTrackInfo) && Objects.equals(this.mEncryptionData, other.mEncryptionData) && Objects.equals(this.mProgramDateTime, other.mProgramDateTime) && Objects.equals(this.mHasDiscontinuity, other.mHasDiscontinuity);
    }

    public String toString() {
        return "(TrackData" + " mUri=" + this.mUri + " mTrackInfo=" + this.mTrackInfo + " mEncryptionData=" + this.mEncryptionData + " mProgramDateTime=" + this.mProgramDateTime + " mHasDiscontinuity=" + this.mHasDiscontinuity + ")";
    }

    public static class Builder {
        private String mUri;
        private TrackInfo mTrackInfo;
        private EncryptionData mEncryptionData;
        private String mProgramDateTime;
        private boolean mHasDiscontinuity;

        public Builder() {
        }

        private Builder(String uri, TrackInfo trackInfo, EncryptionData encryptionData, boolean hasDiscontinuity) {
            this.mUri = uri;
            this.mTrackInfo = trackInfo;
            this.mEncryptionData = encryptionData;
            this.mHasDiscontinuity = hasDiscontinuity;
        }

        public Builder withUri(String url) {
            this.mUri = url;
            return this;
        }

        public Builder withTrackInfo(TrackInfo trackInfo) {
            this.mTrackInfo = trackInfo;
            return this;
        }

        public Builder withEncryptionData(EncryptionData encryptionData) {
            this.mEncryptionData = encryptionData;
            return this;
        }

        public Builder withProgramDateTime(String programDateTime) {
            this.mProgramDateTime = programDateTime;
            return this;
        }

        public Builder withDiscontinuity(boolean hasDiscontinuity) {
            this.mHasDiscontinuity = hasDiscontinuity;
            return this;
        }

        public TrackData build() {
            return new TrackData(this.mUri, this.mTrackInfo, this.mEncryptionData, this.mProgramDateTime, this.mHasDiscontinuity);
        }
    }
}

