/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.IExtTagParser;
import com.iheartradio.m3u8.LineParser;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseState;
import com.iheartradio.m3u8.ParseUtil;
import java.util.regex.Matcher;

class ExtLineParser
implements LineParser {
    private final IExtTagParser mTagParser;
    static final IExtTagParser EXTM3U_HANDLER = new IExtTagParser(){

        @Override
        public String getTag() {
            return "EXTM3U";
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            if (state.isExtended()) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            state.setExtended();
        }
    };
    static final IExtTagParser EXT_UNKNOWN_HANDLER = new IExtTagParser(){

        @Override
        public String getTag() {
            return null;
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            if (state.isMaster()) {
                state.getMaster().unknownTags.add(line);
            } else if (state.isMedia()) {
                state.getMedia().unknownTags.add(line);
            }
        }
    };
    static final IExtTagParser EXT_X_VERSION_HANDLER = new IExtTagParser(){
        private final ExtLineParser mLineParser = new ExtLineParser(this);

        @Override
        public String getTag() {
            return "EXT-X-VERSION";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.mLineParser.parse(line, state);
            Matcher matcher = ParseUtil.match(Constants.EXT_X_VERSION_PATTERN, line, this.getTag());
            if (state.getCompatibilityVersion() != -1) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            int compatibilityVersion = ParseUtil.parseInt(matcher.group(1), this.getTag());
            if (compatibilityVersion < 1) {
                throw ParseException.create(ParseExceptionType.INVALID_COMPATIBILITY_VERSION, this.getTag(), line);
            }
            if (compatibilityVersion > 5) {
                throw ParseException.create(ParseExceptionType.UNSUPPORTED_COMPATIBILITY_VERSION, this.getTag(), line);
            }
            state.setCompatibilityVersion(compatibilityVersion);
        }
    };

    ExtLineParser(IExtTagParser tagParser) {
        this.mTagParser = tagParser;
    }

    @Override
    public void parse(String line, ParseState state) throws ParseException {
        if (this.mTagParser.hasData() && line.indexOf(":") != this.mTagParser.getTag().length() + 1) {
            throw ParseException.create(ParseExceptionType.MISSING_EXT_TAG_SEPARATOR, this.mTagParser.getTag(), line);
        }
    }
}

