/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Attribute;
import com.iheartradio.m3u8.AttributeHandler;
import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.IExtTagHandler;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseState;
import com.iheartradio.m3u8.ParseUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class ExtTagHandler
implements IExtTagHandler {
    static final IExtTagHandler EXTM3U_HANDLER = new ExtTagHandler(){

        @Override
        public String getTag() {
            return "EXTM3U";
        }

        @Override
        boolean hasData() {
            return false;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            if (state.isExtended()) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            state.setExtended();
        }
    };
    static final IExtTagHandler EXT_X_VERSION_HANDLER = new ExtTagHandler(){

        @Override
        public String getTag() {
            return "EXT-X-VERSION";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            super.handle(line, state);
            Matcher matcher = this.match(Constants.EXT_X_VERSION_PATTERN, line);
            if (state.getCompatibilityVersion() != -1) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            int compatibilityVersion = ParseUtil.parseInt(matcher.group(1), this.getTag());
            if (compatibilityVersion < 1) {
                throw ParseException.create(ParseExceptionType.INVALID_COMPATIBILITY_VERSION, this.getTag(), line);
            }
            if (compatibilityVersion > 3) {
                throw ParseException.create(ParseExceptionType.UNSUPPORTED_COMPATIBILITY_VERSION, this.getTag(), line);
            }
            state.setCompatibilityVersion(compatibilityVersion);
        }
    };

    ExtTagHandler() {
    }

    @Override
    public void handle(String line, ParseState state) throws ParseException {
        if (this.hasData() && line.indexOf(":") != this.getTag().length() + 1) {
            throw ParseException.create(ParseExceptionType.MISSING_EXT_TAG_SEPARATOR, this.getTag(), line);
        }
    }

    abstract boolean hasData();

    Matcher match(Pattern pattern, String line) throws ParseException {
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches()) {
            throw ParseException.create(ParseExceptionType.BAD_EXT_TAG_FORMAT, this.getTag(), line);
        }
        return matcher;
    }

    <T> void parseAttributes(String line, T builder, ParseState state, Map<String, AttributeHandler<T>> handlers) throws ParseException {
        for (Attribute attribute : ParseUtil.parseAttributeList(line, this.getTag())) {
            if (handlers.containsKey(attribute.name)) {
                handlers.get(attribute.name).handle(attribute, builder, state);
                continue;
            }
            throw ParseException.create(ParseExceptionType.INVALID_ATTRIBUTE_NAME, this.getTag(), line);
        }
    }
}

