/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.AttributeWriter;
import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.IExtTagWriter;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.TagWriter;
import com.iheartradio.m3u8.data.Playlist;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class ExtTagWriter
implements IExtTagWriter {
    static final IExtTagWriter EXTM3U_HANDLER = new ExtTagWriter(){

        @Override
        public String getTag() {
            return "EXTM3U";
        }

        @Override
        boolean hasData() {
            return false;
        }
    };
    static final IExtTagWriter EXT_UNKNOWN_HANDLER = new ExtTagWriter(){

        @Override
        public String getTag() {
            return null;
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void write(TagWriter tagWriter, Playlist playlist) throws IOException {
            List<Object> unknownTags = playlist.hasMasterPlaylist() && playlist.getMasterPlaylist().hasUnknownTags() ? playlist.getMasterPlaylist().getUnknownTags() : (playlist.getMediaPlaylist().hasUnknownTags() ? playlist.getMediaPlaylist().getUnknownTags() : Collections.emptyList());
            for (String line : unknownTags) {
                tagWriter.writeLine(line);
            }
        }
    };
    static final IExtTagWriter EXT_X_VERSION_HANDLER = new ExtTagWriter(){

        @Override
        public String getTag() {
            return "EXT-X-VERSION";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void write(TagWriter tagWriter, Playlist playlist) throws IOException {
            tagWriter.writeTag(this.getTag(), Integer.toString(playlist.getCompatibilityVersion()));
        }
    };

    ExtTagWriter() {
    }

    @Override
    public void write(TagWriter tagWriter, Playlist playlist) throws IOException, ParseException {
        if (!this.hasData()) {
            tagWriter.writeTag(this.getTag());
        }
    }

    abstract boolean hasData();

    <T> void writeAttributes(TagWriter tagWriter, T attributes, Map<String, ? extends AttributeWriter<T>> attributeWriters) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, AttributeWriter<T>> entry : attributeWriters.entrySet()) {
            AttributeWriter<T> handler = entry.getValue();
            String attribute = entry.getKey();
            if (!handler.containsAttribute(attributes)) continue;
            String value = handler.write(attributes);
            sb.append(attribute).append("=").append(value);
            sb.append(Constants.ATTRIBUTE_LIST_SEPARATOR);
        }
        sb.deleteCharAt(sb.length() - 1);
        tagWriter.writeTag(this.getTag(), sb.toString());
    }
}

