/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.BaseM3uParser;
import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ExtLineParser;
import com.iheartradio.m3u8.IExtTagParser;
import com.iheartradio.m3u8.MasterPlaylistLineParser;
import com.iheartradio.m3u8.MediaPlaylistLineParser;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseState;
import com.iheartradio.m3u8.ParsingMode;
import com.iheartradio.m3u8.PlaylistException;
import com.iheartradio.m3u8.PlaylistLineParser;
import com.iheartradio.m3u8.PlaylistValidation;
import com.iheartradio.m3u8.TrackLineParser;
import com.iheartradio.m3u8.data.Playlist;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

class ExtendedM3uParser
extends BaseM3uParser {
    private final ParsingMode mParsingMode;
    private final Map<String, IExtTagParser> mExtTagParsers = new HashMap<String, IExtTagParser>();

    ExtendedM3uParser(InputStream inputStream, Encoding encoding, ParsingMode parsingMode) {
        super(inputStream, encoding);
        this.mParsingMode = parsingMode;
        this.putParsers(ExtLineParser.EXTM3U_HANDLER, ExtLineParser.EXT_X_VERSION_HANDLER, MediaPlaylistLineParser.EXT_X_PLAYLIST_TYPE, MediaPlaylistLineParser.EXT_X_PROGRAM_DATE_TIME, MediaPlaylistLineParser.EXT_X_KEY, MediaPlaylistLineParser.EXT_X_TARGETDURATION, MediaPlaylistLineParser.EXT_X_START, MediaPlaylistLineParser.EXT_X_MEDIA_SEQUENCE, MediaPlaylistLineParser.EXT_X_I_FRAMES_ONLY, MasterPlaylistLineParser.EXT_X_MEDIA, MediaPlaylistLineParser.EXT_X_ALLOW_CACHE, MasterPlaylistLineParser.EXT_X_STREAM_INF, MasterPlaylistLineParser.EXT_X_I_FRAME_STREAM_INF, MediaPlaylistLineParser.EXTINF, MediaPlaylistLineParser.EXT_X_ENDLIST, MediaPlaylistLineParser.EXT_X_DISCONTINUITY);
    }

    @Override
    public Playlist parse() throws IOException, ParseException, PlaylistException {
        this.validateAvailable();
        ParseState state = new ParseState(this.mEncoding);
        PlaylistLineParser playlistParser = new PlaylistLineParser();
        TrackLineParser trackLineParser = new TrackLineParser();
        try {
            Playlist playlist;
            PlaylistValidation validation;
            while (this.mScanner.hasNext()) {
                String line = this.mScanner.next();
                this.checkWhitespace(line);
                if (line.length() == 0 || this.isComment(line)) continue;
                if (this.isExtTag(line)) {
                    String tagKey = this.getExtTagKey(line);
                    IExtTagParser tagParser = this.mExtTagParsers.get(tagKey);
                    if (tagParser == null) {
                        if (this.mParsingMode.allowUnknownTags) {
                            tagParser = ExtLineParser.EXT_UNKNOWN_HANDLER;
                        } else {
                            throw ParseException.create(ParseExceptionType.UNSUPPORTED_EXT_TAG_DETECTED, tagKey, line);
                        }
                    }
                    tagParser.parse(line, state);
                    if (!state.isMedia() || !state.getMedia().endOfList) continue;
                    break;
                }
                if (state.isMaster()) {
                    playlistParser.parse(line, state);
                    continue;
                }
                if (state.isMedia()) {
                    trackLineParser.parse(line, state);
                    continue;
                }
                throw ParseException.create(ParseExceptionType.UNKNOWN_PLAYLIST_TYPE, line);
            }
            if ((validation = PlaylistValidation.from(playlist = state.buildPlaylist(), this.mParsingMode)).isValid()) {
                return playlist;
            }
            throw new PlaylistException(this.mScanner.getInput(), validation.getErrors());
        }
        catch (ParseException exception) {
            exception.setInput(this.mScanner.getInput());
            throw exception;
        }
    }

    private void putParsers(IExtTagParser ... parsers) {
        if (parsers != null) {
            for (IExtTagParser parser : parsers) {
                this.mExtTagParsers.put(parser.getTag(), parser);
            }
        }
    }

    private void checkWhitespace(String line) throws ParseException {
        if (!this.isComment(line) && line.length() != line.trim().length()) {
            throw ParseException.create(ParseExceptionType.WHITESPACE_IN_TRACK, line);
        }
    }

    private boolean isComment(String line) {
        return line.startsWith("#") && !this.isExtTag(line);
    }

    private boolean isExtTag(String line) {
        return line.startsWith("#EXT");
    }

    private String getExtTagKey(String line) {
        int index = line.indexOf(":");
        if (index == -1) {
            return line.substring(1);
        }
        return line.substring(1, index);
    }
}

