/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ParseException;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Locale;
import java.util.Scanner;

public class ExtendedM3uScanner
implements Closeable {
    private final Scanner mScanner;
    private final StringBuilder mInput = new StringBuilder();
    private boolean mClosed = false;

    ExtendedM3uScanner(InputStream inputStream, Encoding encoding) {
        this.mScanner = new Scanner(inputStream, encoding.value).useLocale(Locale.US).useDelimiter("\\r?\\n");
    }

    @Override
    public void close() {
        this.mScanner.close();
        this.mClosed = true;
    }

    String getInput() {
        return this.mInput.toString();
    }

    boolean hasNext() {
        return !this.mClosed && this.mScanner.hasNext();
    }

    String next() throws ParseException {
        String line = this.mScanner.next();
        this.mInput.append(line);
        return line;
    }
}

