/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ExtTagWriter;
import com.iheartradio.m3u8.MasterPlaylistTagWriter;
import com.iheartradio.m3u8.MediaPlaylistTagWriter;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.PlaylistException;
import com.iheartradio.m3u8.SectionWriter;
import com.iheartradio.m3u8.Writer;
import com.iheartradio.m3u8.data.Playlist;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ExtendedM3uWriter
extends Writer {
    private List<SectionWriter> mExtTagWriter = new ArrayList<SectionWriter>();

    public ExtendedM3uWriter(OutputStream outputStream, Encoding encoding) {
        super(outputStream, encoding);
        this.putWriters(ExtTagWriter.EXTM3U_HANDLER, ExtTagWriter.EXT_X_VERSION_HANDLER, MediaPlaylistTagWriter.EXT_X_PLAYLIST_TYPE, MediaPlaylistTagWriter.EXT_X_TARGETDURATION, MediaPlaylistTagWriter.EXT_X_START, MediaPlaylistTagWriter.EXT_X_MEDIA_SEQUENCE, MediaPlaylistTagWriter.EXT_X_I_FRAMES_ONLY, MasterPlaylistTagWriter.EXT_X_MEDIA, MediaPlaylistTagWriter.EXT_X_ALLOW_CACHE, MasterPlaylistTagWriter.EXT_X_STREAM_INF, MasterPlaylistTagWriter.EXT_X_I_FRAME_STREAM_INF, MediaPlaylistTagWriter.MEDIA_SEGMENTS, MediaPlaylistTagWriter.EXT_X_ENDLIST);
    }

    private void putWriters(SectionWriter ... writers) {
        if (writers != null) {
            Collections.addAll(this.mExtTagWriter, writers);
        }
    }

    @Override
    void doWrite(Playlist playlist) throws IOException, ParseException, PlaylistException {
        for (SectionWriter singleTagWriter : this.mExtTagWriter) {
            singleTagWriter.write(this.tagWriter, playlist);
        }
    }
}

