/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ParseException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Scanner;

class M3uScanner {
    private final Scanner mScanner;
    private final boolean mSupportsByteOrderMark;
    private final StringBuilder mInput = new StringBuilder();
    private boolean mCheckedByteOrderMark;

    M3uScanner(InputStream inputStream, Encoding encoding) {
        this.mScanner = new Scanner(inputStream, encoding.value).useLocale(Locale.US).useDelimiter("\\r?\\n");
        this.mSupportsByteOrderMark = encoding.supportsByteOrderMark;
    }

    String getInput() {
        return this.mInput.toString();
    }

    boolean hasNext() {
        return this.mScanner.hasNext();
    }

    String next() throws ParseException {
        String line = this.mScanner.next();
        if (this.mSupportsByteOrderMark && !this.mCheckedByteOrderMark) {
            if (!line.isEmpty() && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
            }
            this.mCheckedByteOrderMark = true;
        }
        this.mInput.append(line).append("\n");
        return line;
    }
}

