/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Attribute;
import com.iheartradio.m3u8.AttributeParser;
import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.ExtLineParser;
import com.iheartradio.m3u8.IExtTagParser;
import com.iheartradio.m3u8.LineParser;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseState;
import com.iheartradio.m3u8.ParseUtil;
import com.iheartradio.m3u8.data.IFrameStreamInfo;
import com.iheartradio.m3u8.data.MediaData;
import com.iheartradio.m3u8.data.MediaType;
import com.iheartradio.m3u8.data.StreamInfo;
import com.iheartradio.m3u8.data.StreamInfoBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class MasterPlaylistLineParser
implements LineParser {
    private final IExtTagParser mTagParser;
    private final LineParser mLineParser;
    static final IExtTagParser EXT_X_MEDIA = new IExtTagParser(){
        private final LineParser mLineParser = new MasterPlaylistLineParser(this);
        private final Map<String, AttributeParser<MediaData.Builder>> HANDLERS = new HashMap<String, AttributeParser<MediaData.Builder>>();
        {
            this.HANDLERS.put("TYPE", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    MediaType type = MediaType.fromValue(attribute.value);
                    if (type == null) {
                        throw ParseException.create(ParseExceptionType.INVALID_MEDIA_TYPE, this.getTag(), attribute.toString());
                    }
                    builder.withType(type);
                }
            });
            this.HANDLERS.put("URI", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withUri(ParseUtil.decodeUri(ParseUtil.parseQuotedString(attribute.value, this.getTag()), state.encoding));
                }
            });
            this.HANDLERS.put("GROUP-ID", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    String groupId = ParseUtil.parseQuotedString(attribute.value, this.getTag());
                    if (groupId.isEmpty()) {
                        throw ParseException.create(ParseExceptionType.EMPTY_MEDIA_GROUP_ID, this.getTag(), attribute.toString());
                    }
                    builder.withGroupId(groupId);
                }
            });
            this.HANDLERS.put("LANGUAGE", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withLanguage(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("ASSOC-LANGUAGE", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withAssociatedLanguage(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("NAME", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    String name = ParseUtil.parseQuotedString(attribute.value, this.getTag());
                    if (name.isEmpty()) {
                        throw ParseException.create(ParseExceptionType.EMPTY_MEDIA_NAME, this.getTag(), attribute.toString());
                    }
                    builder.withName(name);
                }
            });
            this.HANDLERS.put("DEFAULT", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    boolean isDefault = ParseUtil.parseYesNo(attribute, this.getTag());
                    builder.withDefault(isDefault);
                    state.getMaster().isDefault = isDefault;
                    if (isDefault) {
                        if (state.getMaster().isNotAutoSelect) {
                            throw ParseException.create(ParseExceptionType.AUTO_SELECT_DISABLED_FOR_DEFAULT, this.getTag(), attribute.toString());
                        }
                        builder.withAutoSelect(true);
                    }
                }
            });
            this.HANDLERS.put("AUTOSELECT", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    boolean isAutoSelect = ParseUtil.parseYesNo(attribute, this.getTag());
                    builder.withAutoSelect(isAutoSelect);
                    boolean bl = state.getMaster().isNotAutoSelect = !isAutoSelect;
                    if (state.getMaster().isDefault && !isAutoSelect) {
                        throw ParseException.create(ParseExceptionType.AUTO_SELECT_DISABLED_FOR_DEFAULT, this.getTag(), attribute.toString());
                    }
                }
            });
            this.HANDLERS.put("FORCED", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withForced(ParseUtil.parseYesNo(attribute, this.getTag()));
                }
            });
            this.HANDLERS.put("INSTREAM-ID", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    String inStreamId = ParseUtil.parseQuotedString(attribute.value, this.getTag());
                    if (!Constants.EXT_X_MEDIA_IN_STREAM_ID_PATTERN.matcher(inStreamId).matches()) {
                        throw ParseException.create(ParseExceptionType.INVALID_MEDIA_IN_STREAM_ID, this.getTag(), attribute.toString());
                    }
                    builder.withInStreamId(inStreamId);
                }
            });
            this.HANDLERS.put("CHARACTERISTICS", new AttributeParser<MediaData.Builder>(){

                @Override
                public void parse(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    String[] characteristicStrings = ParseUtil.parseQuotedString(attribute.value, this.getTag()).split(Constants.COMMA);
                    if (characteristicStrings.length == 0) {
                        throw ParseException.create(ParseExceptionType.EMPTY_MEDIA_CHARACTERISTICS, this.getTag(), attribute.toString());
                    }
                    builder.withCharacteristics(Arrays.asList(characteristicStrings));
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-MEDIA";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.mLineParser.parse(line, state);
            MediaData.Builder builder = new MediaData.Builder();
            state.getMaster().clearMediaDataState();
            ParseUtil.parseAttributes(line, builder, state, this.HANDLERS, this.getTag());
            state.getMaster().mediaData.add(builder.build());
        }
    };
    static final IExtTagParser EXT_X_I_FRAME_STREAM_INF = new IExtTagParser(){
        private final LineParser mLineParser = new MasterPlaylistLineParser(this);
        private final Map<String, AttributeParser<IFrameStreamInfo.Builder>> HANDLERS = MasterPlaylistLineParser.makeExtStreamInfHandlers(this.getTag());
        {
            this.HANDLERS.put("URI", new AttributeParser<IFrameStreamInfo.Builder>(){

                @Override
                public void parse(Attribute attribute, IFrameStreamInfo.Builder builder, ParseState state) throws ParseException {
                    builder.withUri(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-I-FRAME-STREAM-INF";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.mLineParser.parse(line, state);
            IFrameStreamInfo.Builder builder = new IFrameStreamInfo.Builder();
            ParseUtil.parseAttributes(line, builder, state, this.HANDLERS, this.getTag());
            state.getMaster().iFramePlaylists.add(builder.build());
        }
    };
    static final IExtTagParser EXT_X_STREAM_INF = new IExtTagParser(){
        private final LineParser mLineParser = new MasterPlaylistLineParser(this);
        private final Map<String, AttributeParser<StreamInfo.Builder>> HANDLERS = MasterPlaylistLineParser.makeExtStreamInfHandlers(this.getTag());
        {
            this.HANDLERS.put("AUDIO", new AttributeParser<StreamInfo.Builder>(){

                @Override
                public void parse(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    builder.withAudio(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("SUBTITLES", new AttributeParser<StreamInfo.Builder>(){

                @Override
                public void parse(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    builder.withSubtitles(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("CLOSED-CAPTIONS", new AttributeParser<StreamInfo.Builder>(){

                @Override
                public void parse(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    if (!attribute.value.equals("NONE")) {
                        builder.withClosedCaptions(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                    }
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-STREAM-INF";
        }

        @Override
        public boolean hasData() {
            return true;
        }

        @Override
        public void parse(String line, ParseState state) throws ParseException {
            this.mLineParser.parse(line, state);
            StreamInfo.Builder builder = new StreamInfo.Builder();
            ParseUtil.parseAttributes(line, builder, state, this.HANDLERS, this.getTag());
            state.getMaster().streamInfo = builder.build();
        }
    };

    MasterPlaylistLineParser(IExtTagParser parser) {
        this(parser, new ExtLineParser(parser));
    }

    MasterPlaylistLineParser(IExtTagParser tagParser, LineParser lineParser) {
        this.mTagParser = tagParser;
        this.mLineParser = lineParser;
    }

    @Override
    public void parse(String line, ParseState state) throws ParseException {
        if (state.isMedia()) {
            throw ParseException.create(ParseExceptionType.MASTER_IN_MEDIA, this.mTagParser.getTag());
        }
        state.setMaster();
        this.mLineParser.parse(line, state);
    }

    static <T extends StreamInfoBuilder> Map<String, AttributeParser<T>> makeExtStreamInfHandlers(final String tag) {
        HashMap<String, AttributeParser<T>> handlers = new HashMap<String, AttributeParser<T>>();
        handlers.put("BANDWIDTH", new AttributeParser<T>(){

            @Override
            public void parse(Attribute attribute, T builder, ParseState state) throws ParseException {
                builder.withBandwidth(ParseUtil.parseInt(attribute.value, tag));
            }
        });
        handlers.put("AVERAGE-BANDWIDTH", new AttributeParser<T>(){

            @Override
            public void parse(Attribute attribute, T builder, ParseState state) throws ParseException {
                builder.withAverageBandwidth(ParseUtil.parseInt(attribute.value, tag));
            }
        });
        handlers.put("CODECS", new AttributeParser<T>(){

            @Override
            public void parse(Attribute attribute, T builder, ParseState state) throws ParseException {
                String[] characteristicStrings = ParseUtil.parseQuotedString(attribute.value, tag).split(Constants.COMMA);
                if (characteristicStrings.length > 0) {
                    builder.withCodecs(Arrays.asList(characteristicStrings));
                }
            }
        });
        handlers.put("RESOLUTION", new AttributeParser<T>(){

            @Override
            public void parse(Attribute attribute, T builder, ParseState state) throws ParseException {
                builder.withResolution(ParseUtil.parseResolution(attribute.value, tag));
            }
        });
        handlers.put("FRAME-RATE", new AttributeParser<T>(){

            @Override
            public void parse(Attribute attribute, T builder, ParseState state) throws ParseException {
                builder.withFrameRate(ParseUtil.parseFloat(attribute.value, tag));
            }
        });
        handlers.put("VIDEO", new AttributeParser<T>(){

            @Override
            public void parse(Attribute attribute, T builder, ParseState state) throws ParseException {
                builder.withVideo(ParseUtil.parseQuotedString(attribute.value, tag));
            }
        });
        handlers.put("PROGRAM-ID", new AttributeParser<T>(){

            @Override
            public void parse(Attribute attribute, T builder, ParseState state) throws ParseException {
            }
        });
        return handlers;
    }
}

