/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Attribute;
import com.iheartradio.m3u8.AttributeHandler;
import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ExtTagHandler;
import com.iheartradio.m3u8.IExtTagHandler;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseState;
import com.iheartradio.m3u8.ParseUtil;
import com.iheartradio.m3u8.data.MediaData;
import com.iheartradio.m3u8.data.MediaType;
import com.iheartradio.m3u8.data.StreamInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class MasterPlaylistTagHandler
extends ExtTagHandler {
    static final IExtTagHandler EXT_X_MEDIA = new MasterPlaylistTagHandler(){
        private final Map<String, AttributeHandler<MediaData.Builder>> HANDLERS = new HashMap<String, AttributeHandler<MediaData.Builder>>();
        private final String TYPE = "TYPE";
        private final String URI = "URI";
        private final String GROUP_ID = "GROUP-ID";
        private final String LANGUAGE = "LANGUAGE";
        private final String ASSOCIATED_LANGUAGE = "ASSOC-LANGUAGE";
        private final String NAME = "NAME";
        private final String DEFAULT = "DEFAULT";
        private final String AUTO_SELECT = "AUTOSELECT";
        private final String FORCED = "FORCED";
        private final String IN_STREAM_ID = "INSTREAM-ID";
        private final String CHARACTERISTICS = "CHARACTERISTICS";
        {
            this.HANDLERS.put("TYPE", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    MediaType type = MediaType.fromValue(attribute.value);
                    if (type == null) {
                        throw ParseException.create(ParseExceptionType.INVALID_MEDIA_TYPE, this.getTag(), attribute.toString());
                    }
                    builder.withType(type);
                }
            });
            this.HANDLERS.put("URI", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withUri(ParseUtil.decodeUrl((String)ParseUtil.parseQuotedString(attribute.value, this.getTag()), (Encoding)state.encoding));
                }
            });
            this.HANDLERS.put("GROUP-ID", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    String groupId = ParseUtil.parseQuotedString(attribute.value, this.getTag());
                    if (groupId.isEmpty()) {
                        throw ParseException.create(ParseExceptionType.EMPTY_MEDIA_GROUP_ID, this.getTag(), attribute.toString());
                    }
                    builder.withGroupId(groupId);
                }
            });
            this.HANDLERS.put("LANGUAGE", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withLanguage(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("ASSOC-LANGUAGE", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withAssociatedLanguage(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("NAME", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    String name = ParseUtil.parseQuotedString(attribute.value, this.getTag());
                    if (name.isEmpty()) {
                        throw ParseException.create(ParseExceptionType.EMPTY_MEDIA_NAME, this.getTag(), attribute.toString());
                    }
                    builder.withName(name);
                }
            });
            this.HANDLERS.put("DEFAULT", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withDefault(ParseUtil.parseYesNo((String)attribute.value, (String)this.getTag()));
                }
            });
            this.HANDLERS.put("AUTOSELECT", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withAutoSelect(ParseUtil.parseYesNo((String)attribute.value, (String)this.getTag()));
                }
            });
            this.HANDLERS.put("FORCED", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    builder.withForced(ParseUtil.parseYesNo((String)attribute.value, (String)this.getTag()));
                }
            });
            this.HANDLERS.put("INSTREAM-ID", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    String inStreamId = ParseUtil.parseQuotedString(attribute.value, this.getTag());
                    if (!Constants.EXT_X_MEDIA_IN_STREAM_ID_PATTERN.matcher(inStreamId).matches()) {
                        throw ParseException.create(ParseExceptionType.INVALID_MEDIA_IN_STREAM_ID, this.getTag(), attribute.toString());
                    }
                    builder.withInStreamId(inStreamId);
                }
            });
            this.HANDLERS.put("CHARACTERISTICS", new AttributeHandler<MediaData.Builder>(){

                @Override
                public void handle(Attribute attribute, MediaData.Builder builder, ParseState state) throws ParseException {
                    String[] characteristicStrings = ParseUtil.parseQuotedString(attribute.value, this.getTag()).split(",");
                    if (characteristicStrings.length == 0) {
                        throw ParseException.create(ParseExceptionType.EMPTY_MEDIA_CHARACTERISTICS, this.getTag(), attribute.toString());
                    }
                    builder.withCharacteristics(Arrays.asList(characteristicStrings));
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-MEDIA";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            super.handle(line, state);
            MediaData.Builder builder = new MediaData.Builder();
            this.parseAttributes(line, builder, state, this.HANDLERS);
            MediaData mediaData = builder.build();
            if (mediaData.getType() == null) {
                throw ParseException.create(ParseExceptionType.MISSING_MEDIA_TYPE, this.getTag(), line);
            }
            if (mediaData.getGroupId() == null) {
                throw ParseException.create(ParseExceptionType.MISSING_MEDIA_GROUP_ID, this.getTag(), line);
            }
            if (mediaData.getName() == null) {
                throw ParseException.create(ParseExceptionType.MISSING_MEDIA_NAME, this.getTag(), line);
            }
            if (mediaData.getType() == MediaType.CLOSED_CAPTIONS && mediaData.getUri() != null) {
                throw ParseException.create(ParseExceptionType.CLOSE_CAPTIONS_WITH_URI, this.getTag(), line);
            }
            if (mediaData.getType() == MediaType.CLOSED_CAPTIONS && mediaData.getInStreamId() == null) {
                throw ParseException.create(ParseExceptionType.CLOSE_CAPTIONS_WITHOUT_IN_STREAM_ID, this.getTag(), line);
            }
            if (mediaData.getType() != MediaType.CLOSED_CAPTIONS && mediaData.getInStreamId() != null) {
                throw ParseException.create(ParseExceptionType.IN_STREAM_ID_WITHOUT_CLOSE_CAPTIONS, this.getTag(), line);
            }
            if (mediaData.isDefault() && builder.isAutoSelectSet() && !mediaData.isAutoSelect()) {
                throw ParseException.create(ParseExceptionType.DEFAULT_WITHOUT_AUTO_SELECT, this.getTag(), line);
            }
            if (mediaData.getType() != MediaType.SUBTITLES && builder.isForcedSet()) {
                throw ParseException.create(ParseExceptionType.FORCED_WITHOUT_SUBTITLES, this.getTag(), line);
            }
            state.getMaster().mediaData.add(mediaData);
        }
    };
    static final IExtTagHandler EXT_X_STREAM_INF = new MasterPlaylistTagHandler(){
        private final Map<String, AttributeHandler<StreamInfo.Builder>> HANDLERS = new HashMap<String, AttributeHandler<StreamInfo.Builder>>();
        private final String BANDWIDTH = "BANDWIDTH";
        private final String AVERAGE_BANDWIDTH = "AVERAGE-BANDWIDTH";
        private final String CODECS = "CODECS";
        private final String RESOLUTION = "RESOLUTION";
        private final String AUDIO = "AUDIO";
        private final String VIDEO = "VIDEO";
        private final String SUBTITLES = "SUBTITLES";
        private final String CLOSED_CAPTIONS = "CLOSED-CAPTIONS";
        private final String PROGRAM_ID = "PROGRAM-ID";
        {
            this.HANDLERS.put("BANDWIDTH", new AttributeHandler<StreamInfo.Builder>(){

                @Override
                public void handle(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    builder.withBandwidth(ParseUtil.parseInt(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("AVERAGE-BANDWIDTH", new AttributeHandler<StreamInfo.Builder>(){

                @Override
                public void handle(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    builder.withAverageBandwidth(ParseUtil.parseInt(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("CODECS", new AttributeHandler<StreamInfo.Builder>(){

                @Override
                public void handle(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    String[] characteristicStrings = ParseUtil.parseQuotedString(attribute.value, this.getTag()).split(",");
                    if (characteristicStrings.length > 0) {
                        builder.withCodecs((List)Arrays.asList(characteristicStrings));
                    }
                }
            });
            this.HANDLERS.put("RESOLUTION", new AttributeHandler<StreamInfo.Builder>(){

                @Override
                public void handle(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    builder.withResolution(ParseUtil.parseResolution(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("AUDIO", new AttributeHandler<StreamInfo.Builder>(){

                @Override
                public void handle(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    builder.withAudio(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("VIDEO", new AttributeHandler<StreamInfo.Builder>(){

                @Override
                public void handle(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    builder.withVideo(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("SUBTITLES", new AttributeHandler<StreamInfo.Builder>(){

                @Override
                public void handle(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    builder.withSubtitles(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("CLOSED-CAPTIONS", new AttributeHandler<StreamInfo.Builder>(){

                @Override
                public void handle(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                    if (!attribute.value.equals("NONE")) {
                        builder.withClosedCaptions(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                    }
                }
            });
            this.HANDLERS.put("PROGRAM-ID", new AttributeHandler<StreamInfo.Builder>(){

                @Override
                public void handle(Attribute attribute, StreamInfo.Builder builder, ParseState state) throws ParseException {
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-STREAM-INF";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            super.handle(line, state);
            StreamInfo.Builder builder = new StreamInfo.Builder();
            this.parseAttributes(line, builder, state, this.HANDLERS);
            StreamInfo streamInfo = builder.build();
            if (!builder.isBandwidthSet()) {
                throw new ParseException(ParseExceptionType.MISSING_STREAM_BANDWIDTH, this.getTag());
            }
            state.getMaster().streamInfo = streamInfo;
        }
    };

    MasterPlaylistTagHandler() {
    }

    @Override
    public void handle(String line, ParseState state) throws ParseException {
        this.validateNotMedia(state);
        state.setMaster();
        super.handle(line, state);
    }

    private void validateNotMedia(ParseState state) throws ParseException {
        if (state.isMedia()) {
            throw ParseException.create(ParseExceptionType.MASTER_IN_MEDIA, this.getTag());
        }
    }
}

