/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.AttributeWriter;
import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.ExtTagWriter;
import com.iheartradio.m3u8.IExtTagWriter;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.TagWriter;
import com.iheartradio.m3u8.WriteUtil;
import com.iheartradio.m3u8.data.IFrameStreamInfo;
import com.iheartradio.m3u8.data.IStreamInfo;
import com.iheartradio.m3u8.data.MasterPlaylist;
import com.iheartradio.m3u8.data.MediaData;
import com.iheartradio.m3u8.data.Playlist;
import com.iheartradio.m3u8.data.PlaylistData;
import com.iheartradio.m3u8.data.StreamInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class MasterPlaylistTagWriter
extends ExtTagWriter {
    static final IExtTagWriter EXT_X_MEDIA = new MasterPlaylistTagWriter(){
        private final Map<String, AttributeWriter<MediaData>> HANDLERS = new HashMap<String, AttributeWriter<MediaData>>();
        {
            this.HANDLERS.put("TYPE", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return true;
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return mediaData.getType().getValue();
                }
            });
            this.HANDLERS.put("URI", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return mediaData.hasUri();
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeQuotedString(mediaData.getUri(), this.getTag());
                }
            });
            this.HANDLERS.put("GROUP-ID", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return true;
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeQuotedString(mediaData.getGroupId(), this.getTag());
                }
            });
            this.HANDLERS.put("LANGUAGE", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return mediaData.hasLanguage();
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeQuotedString(mediaData.getLanguage(), this.getTag());
                }
            });
            this.HANDLERS.put("ASSOC-LANGUAGE", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return mediaData.hasAssociatedLanguage();
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeQuotedString(mediaData.getAssociatedLanguage(), this.getTag());
                }
            });
            this.HANDLERS.put("NAME", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return true;
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeQuotedString(mediaData.getName(), this.getTag());
                }
            });
            this.HANDLERS.put("DEFAULT", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return true;
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeYesNo(mediaData.isDefault());
                }
            });
            this.HANDLERS.put("AUTOSELECT", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return true;
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeYesNo(mediaData.isAutoSelect());
                }
            });
            this.HANDLERS.put("FORCED", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return true;
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeYesNo(mediaData.isForced());
                }
            });
            this.HANDLERS.put("INSTREAM-ID", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return mediaData.hasInStreamId();
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeQuotedString(mediaData.getInStreamId(), this.getTag());
                }
            });
            this.HANDLERS.put("CHARACTERISTICS", new AttributeWriter<MediaData>(){

                @Override
                public boolean containsAttribute(MediaData mediaData) {
                    return mediaData.hasCharacteristics();
                }

                @Override
                public String write(MediaData mediaData) throws ParseException {
                    return WriteUtil.writeQuotedString(WriteUtil.join(mediaData.getCharacteristics(), Constants.COMMA), this.getTag());
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-MEDIA";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MasterPlaylist masterPlaylist) throws IOException, ParseException {
            if (masterPlaylist.getMediaData().size() > 0) {
                List<MediaData> mds = masterPlaylist.getMediaData();
                for (MediaData md : mds) {
                    this.writeAttributes(tagWriter, md, this.HANDLERS);
                }
            }
        }
    };
    static final IExtTagWriter EXT_X_I_FRAME_STREAM_INF = new EXT_STREAM_INF<IFrameStreamInfo>(){
        {
            this.HANDLERS.put("URI", new AttributeWriter<IFrameStreamInfo>(){

                @Override
                public boolean containsAttribute(IFrameStreamInfo streamInfo) {
                    return true;
                }

                @Override
                public String write(IFrameStreamInfo streamInfo) throws ParseException {
                    return WriteUtil.writeQuotedString(streamInfo.getUri(), this.getTag());
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-I-FRAME-STREAM-INF";
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MasterPlaylist masterPlaylist) throws IOException, ParseException {
            for (IFrameStreamInfo streamInfo : masterPlaylist.getIFramePlaylists()) {
                this.writeAttributes(tagWriter, streamInfo, this.HANDLERS);
            }
        }
    };
    static final IExtTagWriter EXT_X_STREAM_INF = new EXT_STREAM_INF<StreamInfo>(){
        {
            this.HANDLERS.put("AUDIO", new AttributeWriter<StreamInfo>(){

                @Override
                public boolean containsAttribute(StreamInfo streamInfo) {
                    return streamInfo.hasAudio();
                }

                @Override
                public String write(StreamInfo streamInfo) throws ParseException {
                    return WriteUtil.writeQuotedString(streamInfo.getAudio(), this.getTag());
                }
            });
            this.HANDLERS.put("SUBTITLES", new AttributeWriter<StreamInfo>(){

                @Override
                public boolean containsAttribute(StreamInfo streamInfo) {
                    return streamInfo.hasSubtitles();
                }

                @Override
                public String write(StreamInfo streamInfo) throws ParseException {
                    return WriteUtil.writeQuotedString(streamInfo.getSubtitles(), this.getTag());
                }
            });
            this.HANDLERS.put("CLOSED-CAPTIONS", new AttributeWriter<StreamInfo>(){

                @Override
                public boolean containsAttribute(StreamInfo streamInfo) {
                    return streamInfo.hasClosedCaptions();
                }

                @Override
                public String write(StreamInfo streamInfo) throws ParseException {
                    return WriteUtil.writeQuotedString(streamInfo.getClosedCaptions(), this.getTag());
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-STREAM-INF";
        }

        @Override
        public void doWrite(TagWriter tagWriter, Playlist playlist, MasterPlaylist masterPlaylist) throws IOException, ParseException {
            for (PlaylistData playlistData : masterPlaylist.getPlaylists()) {
                if (!playlistData.hasStreamInfo()) continue;
                this.writeAttributes(tagWriter, playlistData.getStreamInfo(), this.HANDLERS);
                tagWriter.writeLine(playlistData.getUri());
            }
        }
    };

    MasterPlaylistTagWriter() {
    }

    @Override
    public final void write(TagWriter tagWriter, Playlist playlist) throws IOException, ParseException {
        if (playlist.hasMasterPlaylist()) {
            this.doWrite(tagWriter, playlist, playlist.getMasterPlaylist());
        }
    }

    public void doWrite(TagWriter tagWriter, Playlist playlist, MasterPlaylist masterPlaylist) throws IOException, ParseException {
        tagWriter.writeTag(this.getTag());
    }

    static abstract class EXT_STREAM_INF<T extends IStreamInfo>
    extends MasterPlaylistTagWriter {
        final Map<String, AttributeWriter<T>> HANDLERS = new HashMap<String, AttributeWriter<T>>();

        EXT_STREAM_INF() {
            this.HANDLERS.put("BANDWIDTH", new AttributeWriter<T>(){

                @Override
                public boolean containsAttribute(T streamInfo) {
                    return true;
                }

                @Override
                public String write(T streamInfo) {
                    return Integer.toString(streamInfo.getBandwidth());
                }
            });
            this.HANDLERS.put("AVERAGE-BANDWIDTH", new AttributeWriter<T>(){

                @Override
                public boolean containsAttribute(T streamInfo) {
                    return streamInfo.hasAverageBandwidth();
                }

                @Override
                public String write(T streamInfo) {
                    return Integer.toString(streamInfo.getAverageBandwidth());
                }
            });
            this.HANDLERS.put("CODECS", new AttributeWriter<T>(){

                @Override
                public boolean containsAttribute(T streamInfo) {
                    return streamInfo.hasCodecs();
                }

                @Override
                public String write(T streamInfo) throws ParseException {
                    return WriteUtil.writeQuotedString(WriteUtil.join(streamInfo.getCodecs(), Constants.COMMA), EXT_STREAM_INF.this.getTag());
                }
            });
            this.HANDLERS.put("RESOLUTION", new AttributeWriter<T>(){

                @Override
                public boolean containsAttribute(T streamInfo) {
                    return streamInfo.hasResolution();
                }

                @Override
                public String write(T streamInfo) throws ParseException {
                    return WriteUtil.writeResolution(streamInfo.getResolution());
                }
            });
            this.HANDLERS.put("FRAME-RATE", new AttributeWriter<T>(){

                @Override
                public boolean containsAttribute(T streamInfo) {
                    return streamInfo.hasFrameRate();
                }

                @Override
                public String write(T streamInfo) throws ParseException {
                    return String.valueOf(streamInfo.getFrameRate());
                }
            });
            this.HANDLERS.put("VIDEO", new AttributeWriter<T>(){

                @Override
                public boolean containsAttribute(T streamInfo) {
                    return streamInfo.hasVideo();
                }

                @Override
                public String write(T streamInfo) throws ParseException {
                    return WriteUtil.writeQuotedString(streamInfo.getVideo(), EXT_STREAM_INF.this.getTag());
                }
            });
            this.HANDLERS.put("PROGRAM-ID", new AttributeWriter<T>(){

                @Override
                public boolean containsAttribute(T streamInfo) {
                    return false;
                }

                @Override
                public String write(T streamInfo) {
                    return "";
                }
            });
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public abstract void doWrite(TagWriter var1, Playlist var2, MasterPlaylist var3) throws IOException, ParseException;
    }
}

