/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Attribute;
import com.iheartradio.m3u8.AttributeHandler;
import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ExtTagHandler;
import com.iheartradio.m3u8.IExtTagHandler;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseState;
import com.iheartradio.m3u8.ParseUtil;
import com.iheartradio.m3u8.data.EncryptionData;
import com.iheartradio.m3u8.data.EncryptionMethod;
import com.iheartradio.m3u8.data.TrackInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

abstract class MediaPlaylistTagHandler
extends ExtTagHandler {
    static final IExtTagHandler EXT_X_TARGETDURATION = new MediaPlaylistTagHandler(){

        @Override
        public String getTag() {
            return "EXT-X-TARGETDURATION";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            super.handle(line, state);
            Matcher matcher = this.match(Constants.EXT_X_TARGETDURATION_PATTERN, line);
            if (state.getMedia().targetDuration != null) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            state.getMedia().targetDuration = ParseUtil.parseInt(matcher.group(1), this.getTag());
        }
    };
    static final IExtTagHandler EXT_X_MEDIA_SEQUENCE = new MediaPlaylistTagHandler(){

        @Override
        public String getTag() {
            return "EXT-X-MEDIA-SEQUENCE";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            super.handle(line, state);
            Matcher matcher = this.match(Constants.EXT_X_MEDIA_SEQUENCE_PATTERN, line);
            if (state.getMedia().mediaSequenceNumber != null) {
                throw ParseException.create(ParseExceptionType.MULTIPLE_EXT_TAG_INSTANCES, this.getTag(), line);
            }
            state.getMedia().mediaSequenceNumber = ParseUtil.parseInt(matcher.group(1), this.getTag());
        }
    };
    static final IExtTagHandler EXT_X_ALLOW_CACHE = new ExtTagHandler(){

        @Override
        public String getTag() {
            return "EXT-X-ALLOW-CACHE";
        }

        @Override
        boolean hasData() {
            return false;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            super.handle(line, state);
        }
    };
    static final IExtTagHandler EXT_X_PROGRAM_DATE_TIME = new ExtTagHandler(){

        @Override
        public String getTag() {
            return "EXT-X-PROGRAM-DATE-TIME";
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            super.handle(line, state);
        }
    };
    static final IExtTagHandler EXTINF = new MediaPlaylistTagHandler(){

        @Override
        public String getTag() {
            return "EXTINF";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            super.handle(line, state);
            Matcher matcher = this.match(Constants.EXTINF_PATTERN, line);
            state.getMedia().trackInfo = new TrackInfo(ParseUtil.parseFloat(matcher.group(1), this.getTag()), matcher.group(2));
        }
    };
    static final IExtTagHandler EXT_X_KEY = new MediaPlaylistTagHandler(){
        private final Map<String, AttributeHandler<EncryptionData.Builder>> HANDLERS = new HashMap<String, AttributeHandler<EncryptionData.Builder>>();
        private final String METHOD = "METHOD";
        private final String URI = "URI";
        private final String IV = "IV";
        private final String KEY_FORMAT = "KEYFORMAT";
        private final String KEY_FORMAT_VERSIONS = "KEYFORMATVERSIONS";
        {
            this.HANDLERS.put("METHOD", new AttributeHandler<EncryptionData.Builder>(){

                @Override
                public void handle(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    EncryptionMethod method = EncryptionMethod.fromValue(attribute.value);
                    if (method == null) {
                        throw ParseException.create(ParseExceptionType.INVALID_ENCRYPTION_METHOD, this.getTag(), attribute.toString());
                    }
                    builder.withMethod(method);
                }
            });
            this.HANDLERS.put("URI", new AttributeHandler<EncryptionData.Builder>(){

                @Override
                public void handle(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    builder.withUri(ParseUtil.decodeUrl((String)ParseUtil.parseQuotedString(attribute.value, this.getTag()), (Encoding)state.encoding));
                }
            });
            this.HANDLERS.put("IV", new AttributeHandler<EncryptionData.Builder>(){

                @Override
                public void handle(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    List<Byte> initializationVector = ParseUtil.parseHexadecimal(attribute.value, this.getTag());
                    if (initializationVector.size() != 16) {
                        throw ParseException.create(ParseExceptionType.INVALID_IV_SIZE, this.getTag(), attribute.toString());
                    }
                    builder.withInitializationVector(initializationVector);
                }
            });
            this.HANDLERS.put("KEYFORMAT", new AttributeHandler<EncryptionData.Builder>(){

                @Override
                public void handle(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    builder.withKeyFormat(ParseUtil.parseQuotedString(attribute.value, this.getTag()));
                }
            });
            this.HANDLERS.put("KEYFORMATVERSIONS", new AttributeHandler<EncryptionData.Builder>(){

                @Override
                public void handle(Attribute attribute, EncryptionData.Builder builder, ParseState state) throws ParseException {
                    String[] versionStrings = ParseUtil.parseQuotedString(attribute.value, this.getTag()).split("/");
                    ArrayList<Integer> versions = new ArrayList<Integer>();
                    for (String version : versionStrings) {
                        try {
                            versions.add(Integer.parseInt(version));
                        }
                        catch (NumberFormatException exception) {
                            throw ParseException.create(ParseExceptionType.INVALID_KEY_FORMAT_VERSIONS, this.getTag(), attribute.toString());
                        }
                    }
                    builder.withKeyFormatVersions(versions);
                }
            });
        }

        @Override
        public String getTag() {
            return "EXT-X-KEY";
        }

        @Override
        boolean hasData() {
            return true;
        }

        @Override
        public void handle(String line, ParseState state) throws ParseException {
            super.handle(line, state);
            EncryptionData.Builder builder = new EncryptionData.Builder().withKeyFormat("identity").withKeyFormatVersions(Constants.DEFAULT_KEY_FORMAT_VERSIONS);
            this.parseAttributes(line, builder, state, this.HANDLERS);
            EncryptionData encryptionData = builder.build();
            if (encryptionData.getMethod() != EncryptionMethod.NONE && encryptionData.getUri() == null) {
                throw ParseException.create(ParseExceptionType.MISSING_ENCRYPTION_URI, this.getTag(), line);
            }
            state.getMedia().encryptionData = encryptionData;
        }
    };

    MediaPlaylistTagHandler() {
    }

    @Override
    public void handle(String line, ParseState state) throws ParseException {
        this.validateNotMaster(state);
        state.setMedia();
        super.handle(line, state);
    }

    private void validateNotMaster(ParseState state) throws ParseException {
        if (state.isMaster()) {
            throw ParseException.create(ParseExceptionType.MEDIA_IN_MASTER, this.getTag());
        }
    }
}

