/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.ParseExceptionType;

public class ParseException
extends Exception {
    private static final long serialVersionUID = -2217152001086567983L;
    private final String mMessageSuffix;
    public final ParseExceptionType type;
    private String mInput;

    static ParseException create(ParseExceptionType type, String tag) {
        return ParseException.create(type, tag, null);
    }

    static ParseException create(ParseExceptionType type, String tag, String context) {
        StringBuilder builder = new StringBuilder();
        if (tag != null) {
            builder.append(tag);
        }
        if (context != null) {
            if (builder.length() > 0) {
                builder.append(" - ");
            }
            builder.append(context);
        }
        if (builder.length() > 0) {
            return new ParseException(type, builder.toString());
        }
        return new ParseException(type);
    }

    ParseException(ParseExceptionType type) {
        this(type, null);
    }

    ParseException(ParseExceptionType type, String messageSuffix) {
        this.type = type;
        this.mMessageSuffix = messageSuffix;
    }

    public String getInput() {
        return this.mInput;
    }

    void setInput(String input) {
        this.mInput = input;
    }

    @Override
    public String getMessage() {
        if (this.mMessageSuffix == null) {
            return this.type.message;
        }
        return this.type.message + ": " + this.mMessageSuffix;
    }
}

