/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ExtendedM3uWriter;
import com.iheartradio.m3u8.Format;
import com.iheartradio.m3u8.M3uWriter;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.PlaylistException;
import com.iheartradio.m3u8.PlaylistValidation;
import com.iheartradio.m3u8.Writer;
import com.iheartradio.m3u8.data.Playlist;
import java.io.IOException;
import java.io.OutputStream;

public class PlaylistWriter {
    private final Writer mWriter;
    private final OutputStream mOutputStream;
    private final boolean mShouldWriteByteOrderMark;
    private boolean mFirstWrite = true;

    public PlaylistWriter(OutputStream outputStream, Format format, Encoding encoding) {
        this(outputStream, format, encoding, false);
    }

    private PlaylistWriter(OutputStream outputStream, Format format, Encoding encoding, boolean useByteOrderMark) {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        this.mOutputStream = outputStream;
        this.mShouldWriteByteOrderMark = encoding.supportsByteOrderMark && useByteOrderMark;
        switch (format) {
            case M3U: {
                this.mWriter = new M3uWriter(outputStream, encoding);
                break;
            }
            case EXT_M3U: {
                this.mWriter = new ExtendedM3uWriter(outputStream, encoding);
                break;
            }
            default: {
                throw new RuntimeException("unsupported format detected, this should be impossible: " + (Object)((Object)format));
            }
        }
    }

    public void write(Playlist playlist) throws IOException, ParseException, PlaylistException {
        PlaylistValidation validation = PlaylistValidation.from(playlist);
        if (!validation.isValid()) {
            throw new PlaylistException("", validation.getErrors());
        }
        this.writeByteOrderMark();
        this.mWriter.write(playlist);
        this.mFirstWrite = false;
    }

    private void writeByteOrderMark() throws IOException {
        if (this.mShouldWriteByteOrderMark && this.mFirstWrite) {
            for (int i = 0; i < Constants.UTF_8_BOM_BYTES.length; ++i) {
                this.mOutputStream.write(Constants.UTF_8_BOM_BYTES[i]);
            }
        }
    }

    public static class Builder {
        private OutputStream mOutputStream;
        private Format mFormat;
        private Encoding mEncoding;
        private boolean mUseByteOrderMark;

        public Builder withOutputStream(OutputStream outputStream) {
            this.mOutputStream = outputStream;
            return this;
        }

        public Builder withFormat(Format format) {
            this.mFormat = format;
            return this;
        }

        public Builder withEncoding(Encoding encoding) {
            this.mEncoding = encoding;
            return this;
        }

        public Builder useByteOrderMark() {
            this.mUseByteOrderMark = true;
            return this;
        }

        public PlaylistWriter build() {
            return new PlaylistWriter(this.mOutputStream, this.mFormat, this.mEncoding, this.mUseByteOrderMark);
        }
    }
}

