/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Constants;
import com.iheartradio.m3u8.LineHandler;
import com.iheartradio.m3u8.MediaParseState;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.ParseExceptionType;
import com.iheartradio.m3u8.ParseState;
import com.iheartradio.m3u8.data.TrackData;

class TrackHandler
implements LineHandler {
    TrackHandler() {
    }

    @Override
    public void handle(String line, ParseState state) throws ParseException {
        TrackData.Builder builder = new TrackData.Builder();
        MediaParseState mediaState = state.getMedia();
        if (state.isExtended() && mediaState.trackInfo == null) {
            throw ParseException.create(ParseExceptionType.MISSING_TRACK_INFO, line);
        }
        if (Constants.URL_PATTERN.matcher(line).matches()) {
            builder.withUrl(line);
        } else {
            builder.withPath(line);
        }
        mediaState.tracks.add(builder.withTrackInfo(mediaState.trackInfo).withEncryptionData(mediaState.encryptionData).build());
        mediaState.trackInfo = null;
    }
}

