/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8;

import com.iheartradio.m3u8.Encoding;
import com.iheartradio.m3u8.ParseException;
import com.iheartradio.m3u8.PlaylistException;
import com.iheartradio.m3u8.TagWriter;
import com.iheartradio.m3u8.data.Playlist;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

abstract class Writer {
    final TagWriter tagWriter;

    Writer(OutputStream outputStream, Encoding encoding) {
        try {
            this.tagWriter = new TagWriter(new OutputStreamWriter(outputStream, encoding.getValue()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    void writeTagLine(String tag) throws IOException {
        this.writeLine("#" + tag);
    }

    void writeTagLine(String tag, Object value) throws IOException {
        this.writeLine("#" + tag + ":" + value);
    }

    void writeLine(String line) throws IOException {
        this.tagWriter.write(line);
        this.tagWriter.write("\n");
    }

    final void write(Playlist playlist) throws IOException, ParseException, PlaylistException {
        this.doWrite(playlist);
        this.tagWriter.flush();
    }

    abstract void doWrite(Playlist var1) throws IOException, ParseException, PlaylistException;
}

