/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import com.iheartradio.m3u8.data.EncryptionMethod;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EncryptionData {
    private final EncryptionMethod mMethod;
    private final String mUri;
    private final List<Byte> mInitializationVector;
    private final String mKeyFormat;
    private final List<Integer> mKeyFormatVersions;

    private EncryptionData(EncryptionMethod method, String uri, List<Byte> initializationVector, String keyFormat, List<Integer> keyFormats) {
        this.mMethod = method;
        this.mUri = uri;
        this.mInitializationVector = initializationVector == null ? null : Collections.unmodifiableList(initializationVector);
        this.mKeyFormat = keyFormat;
        this.mKeyFormatVersions = keyFormats == null ? null : Collections.unmodifiableList(keyFormats);
    }

    public EncryptionMethod getMethod() {
        return this.mMethod;
    }

    public boolean hasUri() {
        return this.mUri != null && !this.mUri.isEmpty();
    }

    public String getUri() {
        return this.mUri;
    }

    public boolean hasInitializationVector() {
        return this.mInitializationVector != null;
    }

    public List<Byte> getInitializationVector() {
        return this.mInitializationVector;
    }

    public boolean hasKeyFormat() {
        return this.mKeyFormat != null;
    }

    public String getKeyFormat() {
        return this.mKeyFormat;
    }

    public boolean hasKeyFormatVersions() {
        return this.mKeyFormatVersions != null;
    }

    public List<Integer> getKeyFormatVersions() {
        return this.mKeyFormatVersions;
    }

    public Builder buildUpon() {
        return new Builder(this.mMethod, this.mUri, this.mInitializationVector, this.mKeyFormat, this.mKeyFormatVersions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mInitializationVector, this.mKeyFormat, this.mKeyFormatVersions, this.mMethod, this.mUri});
    }

    public boolean equals(Object o) {
        if (!(o instanceof EncryptionData)) {
            return false;
        }
        EncryptionData other = (EncryptionData)o;
        return Objects.equals(this.mInitializationVector, other.mInitializationVector) && Objects.equals(this.mKeyFormat, other.mKeyFormat) && Objects.equals(this.mKeyFormatVersions, other.mKeyFormatVersions) && Objects.equals((Object)this.mMethod, (Object)other.mMethod) && Objects.equals(this.mUri, other.mUri);
    }

    public static class Builder {
        private EncryptionMethod mMethod;
        private String mUri;
        private List<Byte> mInitializationVector;
        private String mKeyFormat;
        private List<Integer> mKeyFormatVersions;

        public Builder() {
        }

        private Builder(EncryptionMethod method, String uri, List<Byte> initializationVector, String keyFormat, List<Integer> keyFormatVersions) {
            this.mMethod = method;
            this.mUri = uri;
            this.mInitializationVector = initializationVector;
            this.mKeyFormat = keyFormat;
            this.mKeyFormatVersions = keyFormatVersions;
        }

        public Builder withMethod(EncryptionMethod method) {
            this.mMethod = method;
            return this;
        }

        public Builder withUri(String uri) {
            this.mUri = uri;
            return this;
        }

        public Builder withInitializationVector(List<Byte> initializationVector) {
            this.mInitializationVector = initializationVector;
            return this;
        }

        public Builder withKeyFormat(String keyFormat) {
            this.mKeyFormat = keyFormat;
            return this;
        }

        public Builder withKeyFormatVersions(List<Integer> keyFormatVersions) {
            this.mKeyFormatVersions = keyFormatVersions;
            return this;
        }

        public EncryptionData build() {
            return new EncryptionData(this.mMethod, this.mUri, this.mInitializationVector, this.mKeyFormat, this.mKeyFormatVersions);
        }
    }
}

