/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import com.iheartradio.m3u8.data.LocationType;
import com.iheartradio.m3u8.data.ObjectUtil;

public class LocationData {
    private final LocationType mLocationType;
    private final String mLocation;

    public LocationData(LocationType locationType, String location) {
        if (locationType == null) {
            throw new IllegalArgumentException("locationType is null");
        }
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        this.mLocationType = locationType;
        this.mLocation = location;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocationData)) {
            return false;
        }
        LocationData other = (LocationData)o;
        return this.mLocationType == other.mLocationType && ObjectUtil.equals(this.mLocation, other.mLocation);
    }

    public boolean isPath() {
        return this.mLocationType == LocationType.PATH;
    }

    public boolean isUrl() {
        return this.mLocationType == LocationType.URL;
    }

    public LocationType getLocationType() {
        return this.mLocationType;
    }

    public String getLocation() {
        return this.mLocation;
    }
}

