/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import com.iheartradio.m3u8.data.DataUtil;
import com.iheartradio.m3u8.data.IFrameStreamInfo;
import com.iheartradio.m3u8.data.MediaData;
import com.iheartradio.m3u8.data.PlaylistData;
import java.util.List;
import java.util.Objects;

public class MasterPlaylist {
    private final List<PlaylistData> mPlaylists;
    private final List<IFrameStreamInfo> mIFramePlaylists;
    private final List<MediaData> mMediaData;
    private final List<String> mUnknownTags;

    private MasterPlaylist(List<PlaylistData> playlists, List<IFrameStreamInfo> iFramePlaylists, List<MediaData> mediaData, List<String> unknownTags) {
        this.mPlaylists = DataUtil.emptyOrUnmodifiable(playlists);
        this.mIFramePlaylists = DataUtil.emptyOrUnmodifiable(iFramePlaylists);
        this.mMediaData = DataUtil.emptyOrUnmodifiable(mediaData);
        this.mUnknownTags = DataUtil.emptyOrUnmodifiable(unknownTags);
    }

    public List<PlaylistData> getPlaylists() {
        return this.mPlaylists;
    }

    public List<IFrameStreamInfo> getIFramePlaylists() {
        return this.mIFramePlaylists;
    }

    public List<MediaData> getMediaData() {
        return this.mMediaData;
    }

    public boolean hasUnknownTags() {
        return this.mUnknownTags.size() > 0;
    }

    public List<String> getUnknownTags() {
        return this.mUnknownTags;
    }

    public Builder buildUpon() {
        return new Builder(this.mPlaylists, this.mIFramePlaylists, this.mMediaData, this.mUnknownTags);
    }

    public int hashCode() {
        return Objects.hash(this.mMediaData, this.mPlaylists, this.mIFramePlaylists, this.mUnknownTags);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MasterPlaylist)) {
            return false;
        }
        MasterPlaylist other = (MasterPlaylist)o;
        return Objects.equals(this.mMediaData, other.mMediaData) && Objects.equals(this.mPlaylists, other.mPlaylists) && Objects.equals(this.mIFramePlaylists, other.mIFramePlaylists) && Objects.equals(this.mUnknownTags, other.mUnknownTags);
    }

    public String toString() {
        return "(MasterPlaylist" + " mPlaylists=" + this.mPlaylists.toString() + " mIFramePlaylists=" + this.mIFramePlaylists.toString() + " mMediaData=" + this.mMediaData.toString() + " mUnknownTags=" + this.mUnknownTags.toString() + ")";
    }

    public static class Builder {
        private List<PlaylistData> mPlaylists;
        private List<IFrameStreamInfo> mIFramePlaylists;
        private List<MediaData> mMediaData;
        private List<String> mUnknownTags;

        public Builder() {
        }

        private Builder(List<PlaylistData> playlists, List<IFrameStreamInfo> iFramePlaylists, List<MediaData> mediaData, List<String> unknownTags) {
            this.mPlaylists = playlists;
            this.mIFramePlaylists = iFramePlaylists;
            this.mMediaData = mediaData;
            this.mUnknownTags = unknownTags;
        }

        private Builder(List<PlaylistData> playlists, List<MediaData> mediaData) {
            this.mPlaylists = playlists;
            this.mMediaData = mediaData;
        }

        public Builder withPlaylists(List<PlaylistData> playlists) {
            this.mPlaylists = playlists;
            return this;
        }

        public Builder withIFramePlaylists(List<IFrameStreamInfo> iFramePlaylists) {
            this.mIFramePlaylists = iFramePlaylists;
            return this;
        }

        public Builder withMediaData(List<MediaData> mediaData) {
            this.mMediaData = mediaData;
            return this;
        }

        public Builder withUnknownTags(List<String> unknownTags) {
            this.mUnknownTags = unknownTags;
            return this;
        }

        public MasterPlaylist build() {
            return new MasterPlaylist(this.mPlaylists, this.mIFramePlaylists, this.mMediaData, this.mUnknownTags);
        }
    }
}

