/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import com.iheartradio.m3u8.data.DataUtil;
import com.iheartradio.m3u8.data.MediaType;
import java.util.List;
import java.util.Objects;

public class MediaData {
    private final MediaType mType;
    private final String mUri;
    private final String mGroupId;
    private final String mLanguage;
    private final String mAssociatedLanguage;
    private final String mName;
    private final boolean mDefault;
    private final boolean mAutoSelect;
    private final boolean mForced;
    private final String mInStreamId;
    private final List<String> mCharacteristics;

    private MediaData(MediaType type, String uri, String groupId, String language, String associatedLanguage, String name, boolean isDefault, boolean isAutoSelect, boolean isForced, String inStreamId, List<String> characteristics) {
        this.mType = type;
        this.mUri = uri;
        this.mGroupId = groupId;
        this.mLanguage = language;
        this.mAssociatedLanguage = associatedLanguage;
        this.mName = name;
        this.mDefault = isDefault;
        this.mAutoSelect = isAutoSelect;
        this.mForced = isForced;
        this.mInStreamId = inStreamId;
        this.mCharacteristics = DataUtil.emptyOrUnmodifiable(characteristics);
    }

    public MediaType getType() {
        return this.mType;
    }

    public boolean hasUri() {
        return this.mUri != null && !this.mUri.isEmpty();
    }

    public String getUri() {
        return this.mUri;
    }

    public String getGroupId() {
        return this.mGroupId;
    }

    public boolean hasLanguage() {
        return this.mLanguage != null;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public boolean hasAssociatedLanguage() {
        return this.mAssociatedLanguage != null;
    }

    public String getAssociatedLanguage() {
        return this.mAssociatedLanguage;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isDefault() {
        return this.mDefault;
    }

    public boolean isAutoSelect() {
        return this.mAutoSelect;
    }

    public boolean isForced() {
        return this.mForced;
    }

    public boolean hasInStreamId() {
        return this.mInStreamId != null;
    }

    public String getInStreamId() {
        return this.mInStreamId;
    }

    public boolean hasCharacteristics() {
        return !this.mCharacteristics.isEmpty();
    }

    public List<String> getCharacteristics() {
        return this.mCharacteristics;
    }

    public Builder buildUpon() {
        return new Builder(this.mType, this.mUri, this.mGroupId, this.mLanguage, this.mAssociatedLanguage, this.mName, this.mDefault, this.mAutoSelect, this.mForced, this.mInStreamId, this.mCharacteristics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mAssociatedLanguage, this.mAutoSelect, this.mCharacteristics, this.mDefault, this.mForced, this.mGroupId, this.mInStreamId, this.mLanguage, this.mName, this.mType, this.mUri});
    }

    public boolean equals(Object o) {
        if (!(o instanceof MediaData)) {
            return false;
        }
        MediaData other = (MediaData)o;
        return this.mType == other.mType && Objects.equals(this.mUri, other.mUri) && Objects.equals(this.mGroupId, other.mGroupId) && Objects.equals(this.mLanguage, other.mLanguage) && Objects.equals(this.mAssociatedLanguage, other.mAssociatedLanguage) && Objects.equals(this.mName, other.mName) && this.mDefault == other.mDefault && this.mAutoSelect == other.mAutoSelect && this.mForced == other.mForced && Objects.equals(this.mInStreamId, other.mInStreamId) && Objects.equals(this.mCharacteristics, other.mCharacteristics);
    }

    public String toString() {
        return "MediaData [mType=" + (Object)((Object)this.mType) + ", mUri=" + this.mUri + ", mGroupId=" + this.mGroupId + ", mLanguage=" + this.mLanguage + ", mAssociatedLanguage=" + this.mAssociatedLanguage + ", mName=" + this.mName + ", mDefault=" + this.mDefault + ", mAutoSelect=" + this.mAutoSelect + ", mForced=" + this.mForced + ", mInStreamId=" + this.mInStreamId + ", mCharacteristics=" + this.mCharacteristics + "]";
    }

    public static class Builder {
        private MediaType mType;
        private String mUri;
        private String mGroupId;
        private String mLanguage;
        private String mAssociatedLanguage;
        private String mName;
        private boolean mDefault;
        private boolean mAutoSelect;
        private boolean mForced;
        private String mInStreamId;
        private List<String> mCharacteristics;

        public Builder() {
        }

        private Builder(MediaType type, String uri, String groupId, String language, String associatedLanguage, String name, boolean isDefault, boolean autoSelect, boolean forced, String inStreamId, List<String> characteristics) {
            this.mType = type;
            this.mUri = uri;
            this.mGroupId = groupId;
            this.mLanguage = language;
            this.mAssociatedLanguage = associatedLanguage;
            this.mName = name;
            this.mDefault = isDefault;
            this.mAutoSelect = autoSelect;
            this.mForced = forced;
            this.mInStreamId = inStreamId;
            this.mCharacteristics = characteristics;
        }

        public Builder withType(MediaType type) {
            this.mType = type;
            return this;
        }

        public Builder withUri(String uri) {
            this.mUri = uri;
            return this;
        }

        public Builder withGroupId(String groupId) {
            this.mGroupId = groupId;
            return this;
        }

        public Builder withLanguage(String language) {
            this.mLanguage = language;
            return this;
        }

        public Builder withAssociatedLanguage(String associatedLanguage) {
            this.mAssociatedLanguage = associatedLanguage;
            return this;
        }

        public Builder withName(String name) {
            this.mName = name;
            return this;
        }

        public Builder withDefault(boolean isDefault) {
            this.mDefault = isDefault;
            return this;
        }

        public Builder withAutoSelect(boolean isAutoSelect) {
            this.mAutoSelect = isAutoSelect;
            return this;
        }

        public Builder withForced(boolean isForced) {
            this.mForced = isForced;
            return this;
        }

        public Builder withInStreamId(String inStreamId) {
            this.mInStreamId = inStreamId;
            return this;
        }

        public Builder withCharacteristics(List<String> characteristics) {
            this.mCharacteristics = characteristics;
            return this;
        }

        public MediaData build() {
            return new MediaData(this.mType, this.mUri, this.mGroupId, this.mLanguage, this.mAssociatedLanguage, this.mName, this.mDefault, this.mAutoSelect, this.mForced, this.mInStreamId, this.mCharacteristics);
        }
    }
}

