/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import com.iheartradio.m3u8.data.DataUtil;
import com.iheartradio.m3u8.data.PlaylistType;
import com.iheartradio.m3u8.data.StartData;
import com.iheartradio.m3u8.data.TrackData;
import java.util.List;
import java.util.Objects;

public class MediaPlaylist {
    private final List<TrackData> mTracks;
    private final List<String> mUnknownTags;
    private final int mTargetDuration;
    private final int mMediaSequenceNumber;
    private final boolean mIsIframesOnly;
    private final boolean mIsOngoing;
    private final PlaylistType mPlaylistType;
    private final StartData mStartData;

    private MediaPlaylist(List<TrackData> tracks, List<String> unknownTags, int targetDuration, StartData startData, int mediaSequenceNumber, boolean isIframesOnly, boolean isOngoing, PlaylistType playlistType) {
        this.mTracks = DataUtil.emptyOrUnmodifiable(tracks);
        this.mUnknownTags = DataUtil.emptyOrUnmodifiable(unknownTags);
        this.mTargetDuration = targetDuration;
        this.mMediaSequenceNumber = mediaSequenceNumber;
        this.mIsIframesOnly = isIframesOnly;
        this.mIsOngoing = isOngoing;
        this.mStartData = startData;
        this.mPlaylistType = playlistType;
    }

    public boolean hasTracks() {
        return !this.mTracks.isEmpty();
    }

    public List<TrackData> getTracks() {
        return this.mTracks;
    }

    public int getTargetDuration() {
        return this.mTargetDuration;
    }

    public int getMediaSequenceNumber() {
        return this.mMediaSequenceNumber;
    }

    public boolean isIframesOnly() {
        return this.mIsIframesOnly;
    }

    public boolean isOngoing() {
        return this.mIsOngoing;
    }

    public boolean hasUnknownTags() {
        return !this.mUnknownTags.isEmpty();
    }

    public List<String> getUnknownTags() {
        return this.mUnknownTags;
    }

    public StartData getStartData() {
        return this.mStartData;
    }

    public boolean hasStartData() {
        return this.mStartData != null;
    }

    public PlaylistType getPlaylistType() {
        return this.mPlaylistType;
    }

    public boolean hasPlaylistType() {
        return this.mPlaylistType != null;
    }

    public int getDiscontinuitySequenceNumber(int segmentIndex) {
        if (segmentIndex < 0 || segmentIndex >= this.mTracks.size()) {
            throw new IndexOutOfBoundsException();
        }
        int discontinuitySequenceNumber = 0;
        for (int i = 0; i <= segmentIndex; ++i) {
            if (!this.mTracks.get(i).hasDiscontinuity()) continue;
            ++discontinuitySequenceNumber;
        }
        return discontinuitySequenceNumber;
    }

    public Builder buildUpon() {
        return new Builder(this.mTracks, this.mUnknownTags, this.mTargetDuration, this.mMediaSequenceNumber, this.mIsIframesOnly, this.mIsOngoing, this.mPlaylistType, this.mStartData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mTracks, this.mUnknownTags, this.mTargetDuration, this.mMediaSequenceNumber, this.mIsIframesOnly, this.mIsOngoing, this.mPlaylistType, this.mStartData});
    }

    public boolean equals(Object o) {
        if (!(o instanceof MediaPlaylist)) {
            return false;
        }
        MediaPlaylist other = (MediaPlaylist)o;
        return Objects.equals(this.mTracks, other.mTracks) && Objects.equals(this.mUnknownTags, other.mUnknownTags) && this.mTargetDuration == other.mTargetDuration && this.mMediaSequenceNumber == other.mMediaSequenceNumber && this.mIsIframesOnly == other.mIsIframesOnly && this.mIsOngoing == other.mIsOngoing && Objects.equals((Object)this.mPlaylistType, (Object)other.mPlaylistType) && Objects.equals(this.mStartData, other.mStartData);
    }

    public String toString() {
        return "(MediaPlaylist" + " mTracks=" + this.mTracks + " mUnknownTags=" + this.mUnknownTags + " mTargetDuration=" + this.mTargetDuration + " mMediaSequenceNumber=" + this.mMediaSequenceNumber + " mIsIframesOnly=" + this.mIsIframesOnly + " mIsOngoing=" + this.mIsOngoing + " mPlaylistType=" + (Object)((Object)this.mPlaylistType) + " mStartData=" + this.mStartData + ")";
    }

    public static class Builder {
        private List<TrackData> mTracks;
        private List<String> mUnknownTags;
        private int mTargetDuration;
        private int mMediaSequenceNumber;
        private boolean mIsIframesOnly;
        private boolean mIsOngoing;
        private PlaylistType mPlaylistType;
        private StartData mStartData;

        public Builder() {
        }

        private Builder(List<TrackData> tracks, List<String> unknownTags, int targetDuration, int mediaSequenceNumber, boolean isIframesOnly, boolean isOngoing, PlaylistType playlistType, StartData startData) {
            this.mTracks = tracks;
            this.mUnknownTags = unknownTags;
            this.mTargetDuration = targetDuration;
            this.mMediaSequenceNumber = mediaSequenceNumber;
            this.mIsIframesOnly = isIframesOnly;
            this.mIsOngoing = isOngoing;
            this.mPlaylistType = playlistType;
            this.mStartData = startData;
        }

        public Builder withTracks(List<TrackData> tracks) {
            this.mTracks = tracks;
            return this;
        }

        public Builder withUnknownTags(List<String> unknownTags) {
            this.mUnknownTags = unknownTags;
            return this;
        }

        public Builder withTargetDuration(int targetDuration) {
            this.mTargetDuration = targetDuration;
            return this;
        }

        public Builder withStartData(StartData startData) {
            this.mStartData = startData;
            return this;
        }

        public Builder withMediaSequenceNumber(int mediaSequenceNumber) {
            this.mMediaSequenceNumber = mediaSequenceNumber;
            return this;
        }

        public Builder withIsIframesOnly(boolean isIframesOnly) {
            this.mIsIframesOnly = isIframesOnly;
            return this;
        }

        public Builder withIsOngoing(boolean isOngoing) {
            this.mIsOngoing = isOngoing;
            return this;
        }

        public Builder withPlaylistType(PlaylistType playlistType) {
            this.mPlaylistType = playlistType;
            return this;
        }

        public MediaPlaylist build() {
            return new MediaPlaylist(this.mTracks, this.mUnknownTags, this.mTargetDuration, this.mStartData, this.mMediaSequenceNumber, this.mIsIframesOnly, this.mIsOngoing, this.mPlaylistType);
        }
    }
}

