/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import com.iheartradio.m3u8.data.MasterPlaylist;
import com.iheartradio.m3u8.data.MediaPlaylist;
import java.util.Objects;

public class Playlist {
    public static final int MIN_COMPATIBILITY_VERSION = 1;
    private final MasterPlaylist mMasterPlaylist;
    private final MediaPlaylist mMediaPlaylist;
    private final boolean mIsExtended;
    private final int mCompatibilityVersion;

    private Playlist(MasterPlaylist masterPlaylist, MediaPlaylist mediaPlaylist, boolean isExtended, int compatibilityVersion) {
        this.mMasterPlaylist = masterPlaylist;
        this.mMediaPlaylist = mediaPlaylist;
        this.mIsExtended = isExtended;
        this.mCompatibilityVersion = compatibilityVersion;
    }

    public boolean hasMasterPlaylist() {
        return this.mMasterPlaylist != null;
    }

    public boolean hasMediaPlaylist() {
        return this.mMediaPlaylist != null;
    }

    public MasterPlaylist getMasterPlaylist() {
        return this.mMasterPlaylist;
    }

    public MediaPlaylist getMediaPlaylist() {
        return this.mMediaPlaylist;
    }

    public boolean isExtended() {
        return this.mIsExtended;
    }

    public int getCompatibilityVersion() {
        return this.mCompatibilityVersion;
    }

    public Builder buildUpon() {
        return new Builder(this.mMasterPlaylist, this.mMediaPlaylist, this.mIsExtended, this.mCompatibilityVersion);
    }

    public int hashCode() {
        return Objects.hash(this.mCompatibilityVersion, this.mIsExtended, this.mMasterPlaylist, this.mMediaPlaylist);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Playlist)) {
            return false;
        }
        Playlist other = (Playlist)o;
        return Objects.equals(this.mMasterPlaylist, other.mMasterPlaylist) && Objects.equals(this.mMediaPlaylist, other.mMediaPlaylist) && this.mIsExtended == other.mIsExtended && this.mCompatibilityVersion == other.mCompatibilityVersion;
    }

    public String toString() {
        return "(Playlist" + " mMasterPlaylist=" + this.mMasterPlaylist + " mMediaPlaylist=" + this.mMediaPlaylist + " mIsExtended=" + this.mIsExtended + " mCompatibilityVersion=" + this.mCompatibilityVersion + ")";
    }

    public static class Builder {
        private MasterPlaylist mMasterPlaylist;
        private MediaPlaylist mMediaPlaylist;
        private boolean mIsExtended;
        private int mCompatibilityVersion = 1;

        public Builder() {
        }

        private Builder(MasterPlaylist masterPlaylist, MediaPlaylist mediaPlaylist, boolean isExtended, int compatibilityVersion) {
            this.mMasterPlaylist = masterPlaylist;
            this.mMediaPlaylist = mediaPlaylist;
            this.mIsExtended = isExtended;
            this.mCompatibilityVersion = compatibilityVersion;
        }

        public Builder withMasterPlaylist(MasterPlaylist masterPlaylist) {
            this.mMasterPlaylist = masterPlaylist;
            return this.withExtended(true);
        }

        public Builder withMediaPlaylist(MediaPlaylist mediaPlaylist) {
            this.mMediaPlaylist = mediaPlaylist;
            return this;
        }

        public Builder withExtended(boolean isExtended) {
            this.mIsExtended = isExtended;
            return this;
        }

        public Builder withCompatibilityVersion(int version) {
            this.mCompatibilityVersion = version;
            return this;
        }

        public Playlist build() {
            return new Playlist(this.mMasterPlaylist, this.mMediaPlaylist, this.mIsExtended, this.mCompatibilityVersion);
        }
    }
}

