/*
 * Decompiled with CFR 0.152.
 */
package com.iheartradio.m3u8.data;

import java.util.Objects;

public class StartData {
    private final float mTimeOffset;
    private final boolean mPrecise;

    public StartData(float timeOffset, boolean precise) {
        this.mTimeOffset = timeOffset;
        this.mPrecise = precise;
    }

    public float getTimeOffset() {
        return this.mTimeOffset;
    }

    public boolean isPrecise() {
        return this.mPrecise;
    }

    public Builder buildUpon() {
        return new Builder(this.mTimeOffset, this.mPrecise);
    }

    public int hashCode() {
        return Objects.hash(this.mPrecise, Float.valueOf(this.mTimeOffset));
    }

    public boolean equals(Object o) {
        if (!(o instanceof StartData)) {
            return false;
        }
        StartData other = (StartData)o;
        return this.mPrecise == other.mPrecise && this.mTimeOffset == other.mTimeOffset;
    }

    public static class Builder {
        private float mTimeOffset = Float.NaN;
        private boolean mPrecise;

        public Builder() {
        }

        private Builder(float timeOffset, boolean precise) {
            this.mTimeOffset = timeOffset;
            this.mPrecise = precise;
        }

        public Builder withTimeOffset(float timeOffset) {
            this.mTimeOffset = timeOffset;
            return this;
        }

        public Builder withPrecise(boolean precise) {
            this.mPrecise = precise;
            return this;
        }

        public StartData build() {
            return new StartData(this.mTimeOffset, this.mPrecise);
        }
    }
}

