/*
 * Decompiled with CFR 0.152.
 */
package com.ijiami;

import com.ijiami.Base64;
import com.ijiami.LoadMessage;
import com.ijiami.ResultData;
import com.ijiami.Tool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JMEncryptBox {
    private static boolean isRandomDll = false;
    private static List<String> haveLoadedDll = new ArrayList<String>();

    private static native byte[] encryptByType1(byte[] var0);

    private static native byte[] decryptByType1(byte[] var0);

    private static native byte[] encryptByType2(byte[] var0);

    private static native ResultData decryptByType2(byte[] var0);

    private static native String setKey(String var0);

    public static String getVersion() {
        return "3.2";
    }

    public static void setRandomDll(boolean isRandomDll) {
        JMEncryptBox.isRandomDll = isRandomDll;
    }

    public static boolean initLoadDllPath(String baseLibPath) throws RuntimeException {
        return JMEncryptBox.initLoadDllPath(baseLibPath, null);
    }

    public static boolean initLoadDllPath(String baseLibPath, LoadMessage loadMessage) throws RuntimeException {
        String os_name = System.getProperty("os.name").toLowerCase();
        String os_arch = System.getProperty("os.arch");
        String so_name = os_name.contains("window") ? (os_arch.contains("64") ? "JMEncryptBox_x64.dll" : "JMEncryptBox_x86.dll") : (os_name.contains("mac") ? "libJMEncryptBox.dylib" : (os_arch.contains("64") ? "libJMEncryptBox_x64.so" : "libJMEncryptBox_x86.so"));
        File so_file = new File(so_name);
        if (baseLibPath != null && !baseLibPath.equals("")) {
            so_file = new File(baseLibPath, so_name);
        }
        String so_path = so_file.getAbsolutePath();
        boolean isTestMain = false;
        try {
            StackTraceElement[] elements;
            StackTraceElement[] stackTraceElementArray = elements = Thread.currentThread().getStackTrace();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (stackTraceElement.getClassName().equals("com.ijiami.TestMain")) {
                    isTestMain = true;
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!isTestMain) {
            if (loadMessage == null) {
                System.out.println(String.valueOf(so_path) + " ijm start load");
            } else {
                loadMessage.debugLoadMsg(String.valueOf(so_path) + " ijm start load");
            }
        }
        if (!so_file.exists()) {
            if (loadMessage == null) {
                System.out.println("error! so/dll not exist and not loaded, path=" + so_path + " !!!");
            } else {
                loadMessage.debugLoadMsg("error! so/dll not exist and not loaded, path=" + so_path + " !!!");
            }
            return false;
        }
        if (isRandomDll) {
            String filename = so_file.getName();
            long time = System.currentTimeMillis();
            filename = filename.replace(".so", "_" + time + ".so");
            filename = filename.replace(".dll", "_" + time + ".dll");
            filename = filename.replace(".dylib", "_" + time + ".dylib");
            File dir = new File(so_file.getParentFile(), "tmp");
            File[] list = dir.listFiles();
            if (list != null && list.length > 0) {
                File[] fileArray = list;
                int n = list.length;
                int n3 = 0;
                while (n3 < n) {
                    File file = fileArray[n3];
                    String path = file.getAbsolutePath();
                    if (path.endsWith(".so") || path.endsWith(".dll") || path.endsWith(".dylib")) {
                        file.delete();
                    }
                    ++n3;
                }
            }
            File newSofile = new File(dir, filename);
            Tool.copy(so_file, newSofile);
            so_path = newSofile.getAbsolutePath();
        }
        try {
            System.load(so_path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!haveLoadedDll.contains(so_path)) {
            haveLoadedDll.add(so_path);
        }
        if (!isTestMain) {
            if (loadMessage == null) {
                System.out.println(String.valueOf(so_path) + "  loaded success!");
            } else {
                loadMessage.debugLoadMsg(String.valueOf(so_path) + "  loaded success!");
            }
        }
        return true;
    }

    public static String encryptToBase64(String encryStr, int algorithmType) throws Exception {
        try {
            byte[] encrypted = JMEncryptBox.encryptToBytes(encryStr, algorithmType);
            return Base64.encode(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u52a0\u5bc6\u5931\u8d25!");
            return "";
        }
    }

    public static byte[] encryptToBytes(String encrypt, int algorithmType) throws Exception {
        return JMEncryptBox.encryptToBytesFromBytes(encrypt.getBytes("UTF-8"), algorithmType);
    }

    public static byte[] encryptToBytesFromBytes(byte[] dataBytes, int algorithmType) throws Exception {
        if (algorithmType == 2) {
            try {
                byte[] encrypted = JMEncryptBox.encryptByType2(dataBytes);
                return encrypted;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\u52a0\u5bc6\u5931\u8d25!");
                String str = "";
                return str.getBytes();
            }
        }
        try {
            byte[] encrypted = JMEncryptBox.encryptByType1(dataBytes);
            return encrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u52a0\u5bc6\u5931\u8d25!");
            String str = "";
            return str.getBytes();
        }
    }

    public static boolean encryptFile(String srcPath, String targetPath, int algorithmType) {
        try {
            byte[] fileBytes = JMEncryptBox.encryptToBytesFromBytes(JMEncryptBox.readFileToBytes(srcPath), algorithmType);
            return JMEncryptBox.writeFileFromBytes(fileBytes, targetPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ResultData decryptFromBase64(String decryStr, int algorithmType) throws Exception {
        try {
            byte[] encrypt = Base64.decode(decryStr);
            ResultData resultData = JMEncryptBox.decryptFromBytes(encrypt, algorithmType);
            return resultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u89e3\u7801\u9519\u8bef!");
            return new ResultData();
        }
    }

    public static ResultData decryptFromBytes(byte[] decrypt, int algorithmType) throws Exception {
        try {
            ResultData resultData = JMEncryptBox.decryptFromBytesToBytes(decrypt, algorithmType);
            String originalString = new String(resultData.getData(), "UTF-8");
            resultData.setText(originalString);
            return resultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u89e3\u7801\u9519\u8bef!");
            return new ResultData();
        }
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        int i = 0;
        while (i < len) {
            JMEncryptBox.byte2hex(block[i], buf);
            ++i;
        }
        return buf.toString();
    }

    public static ResultData decryptFromBytesToBytes(byte[] dataBytes, int algorithmType) throws Exception {
        if (algorithmType == 2) {
            try {
                ResultData data = JMEncryptBox.decryptByType2(dataBytes);
                return data;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\u89e3\u7801\u9519\u8bef!");
                return new ResultData();
            }
        }
        try {
            byte[] original = JMEncryptBox.decryptByType1(dataBytes);
            ResultData resultData = new ResultData();
            resultData.setData(original);
            if (original.length >= 2) {
                resultData.setStatus(1);
            } else {
                resultData.setStatus(-1);
            }
            return resultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u89e3\u7801\u9519\u8bef!");
            return new ResultData();
        }
    }

    public static boolean decryptFile(String srcPath, String targetPath, int algorithmType) {
        byte[] fileBytes;
        try {
            ResultData resultData = JMEncryptBox.decryptFromBytesToBytes(JMEncryptBox.readFileToBytes(srcPath), algorithmType);
            fileBytes = resultData.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return JMEncryptBox.writeFileFromBytes(fileBytes, targetPath);
    }

    private static byte[] readFileToBytes(String filePath) throws IOException {
        int n;
        byte[] buffer = null;
        File file = new File(filePath);
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fis.close();
        bos.flush();
        bos.close();
        buffer = bos.toByteArray();
        return buffer;
    }

    private static boolean writeFileFromBytes(byte[] fileBytes, String tagPath) {
        if (fileBytes == null) {
            return false;
        }
        boolean result = true;
        try {
            File file = new File(tagPath);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(fileBytes);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }
}

