/*
 * Decompiled with CFR 0.152.
 */
package com.ijiami;

import com.ijiami.Base64;
import com.ijiami.JMEncryptBox;
import com.ijiami.ResultData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class JMEncryptBoxByRandom {
    static {
        new JMEncryptBox();
    }

    private static native byte[] encryptByRandomType1(byte[] var0);

    private static native byte[] decryptByRandomType1(byte[] var0);

    private static native byte[] encryptByRandomType2(byte[] var0);

    private static native ResultData decryptByRandomType2(byte[] var0);

    public static String encryptToBase64(String encryStr, int algorithmType) throws Exception {
        try {
            byte[] encrypted = JMEncryptBoxByRandom.encryptToBytes(encryStr, algorithmType);
            return Base64.encode(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("encryptToBase64 \u52a0\u5bc6\u5931\u8d25!");
            return "";
        }
    }

    public static byte[] encryptToBytes(String encrypt, int algorithmType) throws Exception {
        try {
            return JMEncryptBoxByRandom.encryptToBytesFromBytes(encrypt.getBytes("UTF-8"), algorithmType);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("encryptToBytes \u52a0\u5bc6\u5931\u8d25!");
            String str = "";
            return str.getBytes();
        }
    }

    public static byte[] encryptToBytesFromBytes(byte[] dataBytes, int algorithmType) throws Exception {
        try {
            if (algorithmType == 2) {
                byte[] encrypted = JMEncryptBoxByRandom.encryptByRandomType2(dataBytes);
                return encrypted;
            }
            byte[] encrypted = JMEncryptBoxByRandom.encryptByRandomType1(dataBytes);
            return encrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("encryptToBytesFromBytes \u52a0\u5bc6\u5931\u8d25!");
            String str = "";
            return str.getBytes();
        }
    }

    public static boolean encryptFile(String srcPath, String targetPath, int algorithmType) {
        byte[] fileBytes;
        try {
            fileBytes = JMEncryptBoxByRandom.encryptToBytesFromBytes(JMEncryptBoxByRandom.readFileToBytes(srcPath), algorithmType);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("encryptFile \u52a0\u5bc6\u5931\u8d25!");
            return false;
        }
        return JMEncryptBoxByRandom.writeFileFromBytes(fileBytes, targetPath);
    }

    public static ResultData decryptFromBase64(String decryStr, int algorithmType) throws Exception {
        try {
            byte[] encrypt = Base64.decode(decryStr);
            ResultData resultData = JMEncryptBoxByRandom.decryptFromBytes(encrypt, algorithmType);
            return resultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("decryptFromBase64 \u89e3\u5bc6\u5931\u8d25!");
            return new ResultData();
        }
    }

    public static ResultData decryptFromBytes(byte[] decrypt, int algorithmType) throws Exception {
        try {
            ResultData resultData = JMEncryptBoxByRandom.decryptFromBytesToBytes(decrypt, algorithmType);
            String originalString = new String(resultData.getData(), "UTF-8");
            resultData.setText(originalString);
            return resultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("decryptFromBytes \u89e3\u5bc6\u5931\u8d25!");
            return new ResultData();
        }
    }

    public static ResultData decryptFromBytesToBytes(byte[] dataBytes, int algorithmType) throws Exception {
        try {
            if (algorithmType == 2) {
                ResultData data = JMEncryptBoxByRandom.decryptByRandomType2(dataBytes);
                return data;
            }
            byte[] original = JMEncryptBoxByRandom.decryptByRandomType1(dataBytes);
            ResultData resultData = new ResultData();
            resultData.setData(original);
            if (original.length >= 2) {
                resultData.setStatus(1);
            } else {
                resultData.setStatus(-1);
            }
            return resultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("decryptFromBytesToBytes \u89e3\u5bc6\u5931\u8d25!");
            return new ResultData();
        }
    }

    public static boolean decryptFile(String srcPath, String targetPath, int algorithmType) {
        byte[] fileBytes;
        try {
            ResultData resultData = JMEncryptBoxByRandom.decryptFromBytesToBytes(JMEncryptBoxByRandom.readFileToBytes(srcPath), algorithmType);
            fileBytes = resultData.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("decryptFile \u89e3\u5bc6\u5931\u8d25!");
            return false;
        }
        return JMEncryptBoxByRandom.writeFileFromBytes(fileBytes, targetPath);
    }

    private static byte[] readFileToBytes(String filePath) throws IOException {
        int n;
        byte[] buffer = null;
        File file = new File(filePath);
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fis.close();
        bos.flush();
        bos.close();
        buffer = bos.toByteArray();
        return buffer;
    }

    private static boolean writeFileFromBytes(byte[] fileBytes, String tagPath) {
        if (fileBytes == null) {
            return false;
        }
        boolean result = true;
        try {
            File file = new File(tagPath);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(fileBytes);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }
}

