/*
 * Decompiled with CFR 0.152.
 */
package com.ijiami;

import com.ijiami.Base64;
import com.ijiami.EncryptionMode;
import com.ijiami.JMEncryptBox;
import com.ijiami.ResultData;

public class JMEncryptBoxByUnidirectional {
    static {
        new JMEncryptBox();
    }

    private static native ResultData dNormalModePreA(byte[] var0);

    private static native ResultData dRandomModePreA(byte[] var0);

    private static native byte[] eNormalModePreB(byte[] var0);

    private static native byte[] eRandomModePreB(byte[] var0);

    public static String encryptToBase64(String encryStr, EncryptionMode mode) throws Exception {
        try {
            byte[] encrypted = JMEncryptBoxByUnidirectional.encryptToBytes(encryStr, mode);
            return Base64.encode(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("encryptToBase64 \u52a0\u5bc6\u5931\u8d25!");
            return "";
        }
    }

    public static byte[] encryptToBytes(String encrypt, EncryptionMode mode) throws Exception {
        return JMEncryptBoxByUnidirectional.encryptToBytesFromBytes(encrypt.getBytes("UTF-8"), mode);
    }

    public static byte[] encryptToBytesFromBytes(byte[] dataBytes, EncryptionMode mode) throws Exception {
        try {
            if (mode == EncryptionMode.NormalMode) {
                byte[] encrypted = JMEncryptBoxByUnidirectional.eNormalModePreB(dataBytes);
                return encrypted;
            }
            byte[] encrypted = JMEncryptBoxByUnidirectional.eRandomModePreB(dataBytes);
            return encrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("encryptToBytesFromBytes \u52a0\u5bc6\u5931\u8d25!");
            String str = "";
            return str.getBytes();
        }
    }

    public static ResultData decryptFromBase64(String decryStr, EncryptionMode mode) throws Exception {
        try {
            byte[] encrypt = Base64.decode(decryStr);
            ResultData resultData = JMEncryptBoxByUnidirectional.decryptFromBytes(encrypt, mode);
            return resultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("decryptFromBase64 \u89e3\u5bc6\u5931\u8d25!");
            return new ResultData();
        }
    }

    public static ResultData decryptFromBytes(byte[] decrypt, EncryptionMode mode) throws Exception {
        try {
            ResultData resultData = JMEncryptBoxByUnidirectional.decryptFromBytesToBytes(decrypt, mode);
            String originalString = new String(resultData.getData(), "UTF-8");
            resultData.setText(originalString);
            return resultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("decryptFromBytes \u89e3\u5bc6\u5931\u8d25!");
            return new ResultData();
        }
    }

    public static ResultData decryptFromBytesToBytes(byte[] dataBytes, EncryptionMode mode) throws Exception {
        try {
            if (mode == EncryptionMode.NormalMode) {
                ResultData resultData = JMEncryptBoxByUnidirectional.dNormalModePreA(dataBytes);
                return resultData;
            }
            ResultData resultData = JMEncryptBoxByUnidirectional.dRandomModePreA(dataBytes);
            return resultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("decryptFromBytesToBytes \u89e3\u5bc6\u5931\u8d25!");
            return new ResultData();
        }
    }
}

