/*
 * Influx OSS API Service
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.AxisScale;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * The description of a particular axis for a visualization.
 */
@ApiModel(description = "The description of a particular axis for a visualization.")

public class Axis {
  public static final String SERIALIZED_NAME_BOUNDS = "bounds";
  @SerializedName(SERIALIZED_NAME_BOUNDS)
  private List<String> bounds = new ArrayList<>();

  public static final String SERIALIZED_NAME_LABEL = "label";
  @SerializedName(SERIALIZED_NAME_LABEL)
  private String label;

  public static final String SERIALIZED_NAME_PREFIX = "prefix";
  @SerializedName(SERIALIZED_NAME_PREFIX)
  private String prefix;

  public static final String SERIALIZED_NAME_SUFFIX = "suffix";
  @SerializedName(SERIALIZED_NAME_SUFFIX)
  private String suffix;

  /**
   * Base represents the radix for formatting axis values.
   */
  @JsonAdapter(BaseEnum.Adapter.class)
  public enum BaseEnum {
    EMPTY(""),
    
    _2("2"),
    
    _10("10");

    private String value;

    BaseEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BaseEnum fromValue(String text) {
      for (BaseEnum b : BaseEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<BaseEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BaseEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BaseEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return BaseEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_BASE = "base";
  @SerializedName(SERIALIZED_NAME_BASE)
  private BaseEnum base;

  public static final String SERIALIZED_NAME_SCALE = "scale";
  @SerializedName(SERIALIZED_NAME_SCALE)
  private AxisScale scale = null;

  public Axis bounds(List<String> bounds) {
    this.bounds = bounds;
    return this;
  }

  public Axis addBoundsItem(String boundsItem) {
    if (this.bounds == null) {
      this.bounds = new ArrayList<>();
    }
    this.bounds.add(boundsItem);
    return this;
  }

   /**
   * The extents of an axis in the form [lower, upper]. Clients determine whether bounds are to be inclusive or exclusive of their limits
   * @return bounds
  **/
  @ApiModelProperty(value = "The extents of an axis in the form [lower, upper]. Clients determine whether bounds are to be inclusive or exclusive of their limits")
  public List<String> getBounds() {
    return bounds;
  }

  public void setBounds(List<String> bounds) {
    this.bounds = bounds;
  }

  public Axis label(String label) {
    this.label = label;
    return this;
  }

   /**
   * Label is a description of this Axis
   * @return label
  **/
  @ApiModelProperty(value = "Label is a description of this Axis")
  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public Axis prefix(String prefix) {
    this.prefix = prefix;
    return this;
  }

   /**
   * Prefix represents a label prefix for formatting axis values.
   * @return prefix
  **/
  @ApiModelProperty(value = "Prefix represents a label prefix for formatting axis values.")
  public String getPrefix() {
    return prefix;
  }

  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }

  public Axis suffix(String suffix) {
    this.suffix = suffix;
    return this;
  }

   /**
   * Suffix represents a label suffix for formatting axis values.
   * @return suffix
  **/
  @ApiModelProperty(value = "Suffix represents a label suffix for formatting axis values.")
  public String getSuffix() {
    return suffix;
  }

  public void setSuffix(String suffix) {
    this.suffix = suffix;
  }

  public Axis base(BaseEnum base) {
    this.base = base;
    return this;
  }

   /**
   * Base represents the radix for formatting axis values.
   * @return base
  **/
  @ApiModelProperty(value = "Base represents the radix for formatting axis values.")
  public BaseEnum getBase() {
    return base;
  }

  public void setBase(BaseEnum base) {
    this.base = base;
  }

  public Axis scale(AxisScale scale) {
    this.scale = scale;
    return this;
  }

   /**
   * Get scale
   * @return scale
  **/
  @ApiModelProperty(value = "")
  public AxisScale getScale() {
    return scale;
  }

  public void setScale(AxisScale scale) {
    this.scale = scale;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Axis axis = (Axis) o;
    return Objects.equals(this.bounds, axis.bounds) &&
        Objects.equals(this.label, axis.label) &&
        Objects.equals(this.prefix, axis.prefix) &&
        Objects.equals(this.suffix, axis.suffix) &&
        Objects.equals(this.base, axis.base) &&
        Objects.equals(this.scale, axis.scale);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bounds, label, prefix, suffix, base, scale);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Axis {\n");
    sb.append("    bounds: ").append(toIndentedString(bounds)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    prefix: ").append(toIndentedString(prefix)).append("\n");
    sb.append("    suffix: ").append(toIndentedString(suffix)).append("\n");
    sb.append("    base: ").append(toIndentedString(base)).append("\n");
    sb.append("    scale: ").append(toIndentedString(scale)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

