/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.AuthorizationsApi;
import com.influxdb.client.domain.Authorization;
import com.influxdb.client.domain.AuthorizationPostRequest;
import com.influxdb.client.domain.AuthorizationUpdateRequest;
import com.influxdb.client.domain.Authorizations;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.Permission;
import com.influxdb.client.domain.User;
import com.influxdb.client.service.AuthorizationsService;
import com.influxdb.internal.AbstractRestClient;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class AuthorizationsApiImpl
extends AbstractRestClient
implements AuthorizationsApi {
    private static final Logger LOG = Logger.getLogger(AuthorizationsApiImpl.class.getName());
    private final AuthorizationsService service;

    AuthorizationsApiImpl(@Nonnull AuthorizationsService service) {
        Arguments.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Authorization createAuthorization(@Nonnull Organization organization, @Nonnull List<Permission> permissions) {
        Arguments.checkNotNull((Object)organization, (String)"Organization is required");
        Arguments.checkNotNull(permissions, (String)"Permissions are required");
        return this.createAuthorization(organization.getId(), permissions);
    }

    @Override
    @Nonnull
    public Authorization createAuthorization(@Nonnull String orgID, @Nonnull List<Permission> permissions) {
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Arguments.checkNotNull(permissions, (String)"Permissions are required");
        Authorization authorization = new Authorization();
        authorization.setOrgID(orgID);
        authorization.setPermissions(permissions);
        authorization.setStatus(AuthorizationUpdateRequest.StatusEnum.ACTIVE);
        return this.createAuthorization(authorization);
    }

    @Override
    @Nonnull
    public Authorization createAuthorization(@Nonnull Authorization authorization) {
        Arguments.checkNotNull((Object)authorization, (String)"Authorization is required");
        AuthorizationPostRequest request = new AuthorizationPostRequest();
        request.orgID(authorization.getOrgID()).userID(authorization.getUserID()).permissions(authorization.getPermissions()).description(authorization.getDescription());
        Call<Authorization> call = this.service.postAuthorizations(request, null);
        return (Authorization)this.execute(call);
    }

    @Override
    @Nonnull
    public List<Authorization> findAuthorizations() {
        return this.findAuthorizationsByUserID(null);
    }

    @Override
    @Nonnull
    public Authorization findAuthorizationByID(@Nonnull String authorizationID) {
        Arguments.checkNonEmpty((String)authorizationID, (String)"authorizationID");
        Call<Authorization> call = this.service.getAuthorizationsID(authorizationID, null);
        return (Authorization)this.execute(call);
    }

    @Override
    @Nonnull
    public List<Authorization> findAuthorizationsByUser(@Nonnull User user) {
        Arguments.checkNotNull((Object)user, (String)"User is required");
        return this.findAuthorizations(user.getId(), null, null);
    }

    @Override
    @Nonnull
    public List<Authorization> findAuthorizationsByUserID(@Nullable String userID) {
        return this.findAuthorizations(userID, null, null);
    }

    @Override
    @Nonnull
    public List<Authorization> findAuthorizationsByUserName(@Nullable String userName) {
        return this.findAuthorizations(null, userName, null);
    }

    @Override
    @Nonnull
    public List<Authorization> findAuthorizationsByOrg(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"organization");
        return this.findAuthorizationsByOrgID(organization.getId());
    }

    @Override
    @Nonnull
    public List<Authorization> findAuthorizationsByOrgID(@Nullable String orgID) {
        return this.findAuthorizations(null, null, orgID);
    }

    @Override
    @Nonnull
    public Authorization updateAuthorization(@Nonnull Authorization authorization) {
        Arguments.checkNotNull((Object)authorization, (String)"Authorization is required");
        Call<Authorization> authorizationCall = this.service.patchAuthorizationsID(authorization.getId(), authorization, null);
        return (Authorization)this.execute(authorizationCall);
    }

    @Override
    public void deleteAuthorization(@Nonnull Authorization authorization) {
        Arguments.checkNotNull((Object)authorization, (String)"Authorization is required");
        this.deleteAuthorization(authorization.getId());
    }

    @Override
    public void deleteAuthorization(@Nonnull String authorizationID) {
        Arguments.checkNonEmpty((String)authorizationID, (String)"authorizationID");
        Call<Void> call = this.service.deleteAuthorizationsID(authorizationID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Authorization cloneAuthorization(@Nonnull String authorizationID) {
        Arguments.checkNonEmpty((String)authorizationID, (String)"authorizationID");
        Authorization authorization = this.findAuthorizationByID(authorizationID);
        return this.cloneAuthorization(authorization);
    }

    @Override
    @Nonnull
    public Authorization cloneAuthorization(@Nonnull Authorization authorization) {
        Arguments.checkNotNull((Object)authorization, (String)"authorization");
        Authorization cloned = new Authorization();
        cloned.setOrgID(authorization.getOrgID());
        cloned.setStatus(AuthorizationUpdateRequest.StatusEnum.ACTIVE);
        cloned.setDescription(authorization.getDescription());
        cloned.setPermissions(authorization.getPermissions());
        return this.createAuthorization(cloned);
    }

    @Nonnull
    private List<Authorization> findAuthorizations(@Nullable String userID, @Nullable String userName, @Nullable String orgID) {
        Call<Authorizations> authorizationsCall = this.service.getAuthorizations(null, userID, userName, orgID, null);
        Authorizations authorizations = (Authorizations)this.execute(authorizationsCall);
        LOG.log(Level.FINEST, "findAuthorizations found: {0}", authorizations);
        return authorizations.getAuthorizations();
    }
}

