/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.DeleteApi;
import com.influxdb.client.domain.Bucket;
import com.influxdb.client.domain.DeletePredicateRequest;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.service.DeleteService;
import com.influxdb.internal.AbstractRestClient;
import java.time.OffsetDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import retrofit2.Call;

public class DeleteApiImpl
extends AbstractRestClient
implements DeleteApi {
    private static final Logger LOG = Logger.getLogger(DeleteApiImpl.class.getName());
    private final DeleteService service;

    DeleteApiImpl(@Nonnull DeleteService service) {
        Arguments.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    public void delete(@Nonnull OffsetDateTime start, @Nonnull OffsetDateTime stop, @Nonnull String predicate, @Nonnull Bucket bucket, @Nonnull Organization org) {
        Arguments.checkNotNull((Object)start, (String)"Start is required");
        Arguments.checkNotNull((Object)stop, (String)"Stop is required");
        Arguments.checkNotNull((Object)predicate, (String)"Predicate is required");
        Arguments.checkNotNull((Object)bucket, (String)"Bucket is required");
        Arguments.checkNotNull((Object)org, (String)"Organization is required");
        this.delete(start, stop, predicate, bucket.getId(), org.getId());
    }

    @Override
    public void delete(@Nonnull OffsetDateTime start, @Nonnull OffsetDateTime stop, @Nonnull String predicate, @Nonnull String bucket, @Nonnull String org) {
        Arguments.checkNotNull((Object)start, (String)"Start is required");
        Arguments.checkNotNull((Object)stop, (String)"Stop is required");
        Arguments.checkNotNull((Object)predicate, (String)"Predicate is required");
        Arguments.checkNonEmpty((String)bucket, (String)"Bucket is required");
        Arguments.checkNonEmpty((String)org, (String)"Organization is required");
        DeletePredicateRequest request = new DeletePredicateRequest();
        request.setStart(start);
        request.setStop(stop);
        request.setPredicate(predicate);
        this.delete(request, bucket, org);
    }

    @Override
    public void delete(@Nonnull DeletePredicateRequest predicate, @Nonnull String bucket, @Nonnull String org) {
        Arguments.checkNotNull((Object)predicate, (String)"Predicate is required");
        Arguments.checkNonEmpty((String)bucket, (String)"Bucket is required");
        Arguments.checkNonEmpty((String)org, (String)"Organization is required");
        LOG.log(Level.FINEST, "Deleting time-series data from InfluxDB (org={0}, bucket={1})...", new Object[]{org, bucket});
        Call<Void> call = this.service.postDelete(predicate, null, org, bucket, null, null);
        this.execute(call);
        LOG.log(Level.FINEST, "Data was deleted from InfluxDB: (org={0}, bucket={1})", new Object[]{org, bucket});
    }
}

