/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.Logger;
import java.util.concurrent.Callable;

public final class VerboseRunnable
implements Runnable {
    private final transient Runnable origin;
    private final transient boolean swallow;
    private final transient boolean verbose;

    public VerboseRunnable(Runnable runnable) {
        this(runnable, false);
    }

    public VerboseRunnable(Callable<?> callable) {
        this(callable, false);
    }

    public VerboseRunnable(Callable<?> callable, boolean swallowexceptions) {
        this(callable, swallowexceptions, true);
    }

    public VerboseRunnable(final Callable<?> callable, boolean swallowexceptions, boolean fullstacktrace) {
        this(new Runnable(){

            @Override
            public void run() {
                try {
                    callable.call();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }

            public String toString() {
                return callable.toString();
            }
        }, swallowexceptions, fullstacktrace);
    }

    public VerboseRunnable(Runnable runnable, boolean swallowexceptions) {
        this(runnable, swallowexceptions, true);
    }

    public VerboseRunnable(Runnable runnable, boolean swallowexceptions, boolean fullstacktrace) {
        this.origin = runnable;
        this.swallow = swallowexceptions;
        this.verbose = fullstacktrace;
    }

    @Override
    public void run() {
        try {
            this.origin.run();
        }
        catch (RuntimeException ex) {
            if (!this.swallow) {
                Logger.warn(this, "escalated exception: %s", this.tail(ex));
                throw ex;
            }
            Logger.warn(this, "swallowed exception: %s", this.tail(ex));
        }
        catch (Error error) {
            if (!this.swallow) {
                Logger.error(this, "escalated error: %s", this.tail(error));
                throw error;
            }
            Logger.error(this, "swallowed error: %s", this.tail(error));
        }
        if (this.swallow) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ex) {
                Logger.debug(this, "interrupted status cleared of %s: %s", Thread.currentThread().getName(), ex);
            }
        }
    }

    private String tail(Throwable throwable) {
        String tail = this.verbose ? Logger.format("%[exception]s", throwable) : Logger.format("%[type]s('%s')", throwable, throwable.getMessage());
        return tail;
    }

    public String toString() {
        return "VerboseRunnable(origin=" + this.origin + ", swallow=" + this.swallow + ", verbose=" + this.verbose + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerboseRunnable)) {
            return false;
        }
        VerboseRunnable other = (VerboseRunnable)o;
        Runnable this$origin = this.origin;
        Runnable other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        return this.swallow == other.swallow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Runnable $origin = this.origin;
        result = result * 59 + ($origin == null ? 0 : $origin.hashCode());
        result = result * 59 + (this.swallow ? 79 : 97);
        return result;
    }
}

