// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.admin.v1;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.admin.v1.model.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class AdminService {

    private final Config config;
    private final AdminDeptStats adminDeptStats;
    private final AdminUserStats adminUserStats;

    public AdminService(Config config) {
        this.config = config;
        this.adminDeptStats = new AdminDeptStats(this);
        this.adminUserStats = new AdminUserStats(this);
    }

    public AdminDeptStats getAdminDeptStats() {
        return adminDeptStats;
    }

    public static class AdminDeptStats {

        private final AdminService service;

        public AdminDeptStats(AdminService service) {
            this.service = service;
        }
    
        public AdminDeptStatListReqCall list(RequestOptFn... optFns) {
            return new AdminDeptStatListReqCall(this, optFns);
        }
    
    }
    public static class AdminDeptStatListReqCall extends ReqCaller<Object, AdminDeptStatListResult> {
        private final AdminDeptStats adminDeptStats;
        
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private AdminDeptStatListResult result;
        
        private AdminDeptStatListReqCall(AdminDeptStats adminDeptStats, RequestOptFn... optFns) {
        
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AdminDeptStatListResult();
            this.adminDeptStats = adminDeptStats;
        }
        
        
        public AdminDeptStatListReqCall setDepartmentIdType(String departmentIdType){
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }
        public AdminDeptStatListReqCall setStartDate(String startDate){
            this.queryParams.put("start_date", startDate);
            return this;
        }
        public AdminDeptStatListReqCall setEndDate(String endDate){
            this.queryParams.put("end_date", endDate);
            return this;
        }
        public AdminDeptStatListReqCall setDepartmentId(String departmentId){
            this.queryParams.put("department_id", departmentId);
            return this;
        }
        public AdminDeptStatListReqCall setContainsChildDept(Boolean containsChildDept){
            this.queryParams.put("contains_child_dept", containsChildDept);
            return this;
        }
        public AdminDeptStatListReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }
        public AdminDeptStatListReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        @Override
        public Response<AdminDeptStatListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, AdminDeptStatListResult> request = Request.newRequest("admin/v1/admin_dept_stats", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.adminDeptStats.service.config, request);
        }
    }

    public AdminUserStats getAdminUserStats() {
        return adminUserStats;
    }

    public static class AdminUserStats {

        private final AdminService service;

        public AdminUserStats(AdminService service) {
            this.service = service;
        }
    
        public AdminUserStatListReqCall list(RequestOptFn... optFns) {
            return new AdminUserStatListReqCall(this, optFns);
        }
    
    }
    public static class AdminUserStatListReqCall extends ReqCaller<Object, AdminUserStatListResult> {
        private final AdminUserStats adminUserStats;
        
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private AdminUserStatListResult result;
        
        private AdminUserStatListReqCall(AdminUserStats adminUserStats, RequestOptFn... optFns) {
        
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AdminUserStatListResult();
            this.adminUserStats = adminUserStats;
        }
        
        
        public AdminUserStatListReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }
        public AdminUserStatListReqCall setDepartmentIdType(String departmentIdType){
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }
        public AdminUserStatListReqCall setStartDate(String startDate){
            this.queryParams.put("start_date", startDate);
            return this;
        }
        public AdminUserStatListReqCall setEndDate(String endDate){
            this.queryParams.put("end_date", endDate);
            return this;
        }
        public AdminUserStatListReqCall setDepartmentId(String departmentId){
            this.queryParams.put("department_id", departmentId);
            return this;
        }
        public AdminUserStatListReqCall setUserId(String userId){
            this.queryParams.put("user_id", userId);
            return this;
        }
        public AdminUserStatListReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }
        public AdminUserStatListReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        @Override
        public Response<AdminUserStatListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, AdminUserStatListResult> request = Request.newRequest("admin/v1/admin_user_stats", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.adminUserStats.service.config, request);
        }
    }

}
