// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.calendar.v4;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.calendar.v4.model.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class CalendarService {

    private final Config config;
    private final Calendars calendars;
    private final CalendarAcls calendarAcls;
    private final CalendarEvents calendarEvents;
    private final CalendarEventAttendees calendarEventAttendees;
    private final CalendarEventAttendeeChatMembers calendarEventAttendeeChatMembers;
    private final Freebusys freebusys;
    private final Settings settings;
    private final TimeoffEvents timeoffEvents;
    private final ExchangeBindings exchangeBindings;

    public CalendarService(Config config) {
        this.config = config;
        this.calendars = new Calendars(this);
        this.calendarAcls = new CalendarAcls(this);
        this.calendarEvents = new CalendarEvents(this);
        this.calendarEventAttendees = new CalendarEventAttendees(this);
        this.calendarEventAttendeeChatMembers = new CalendarEventAttendeeChatMembers(this);
        this.freebusys = new Freebusys(this);
        this.settings = new Settings(this);
        this.timeoffEvents = new TimeoffEvents(this);
        this.exchangeBindings = new ExchangeBindings(this);
    }

    public Calendars getCalendars() {
        return calendars;
    }

    public static class Calendars {

        private final CalendarService service;

        public Calendars(CalendarService service) {
            this.service = service;
        }
    
        public CalendarCreateReqCall create(Calendar body, RequestOptFn... optFns) {
            return new CalendarCreateReqCall(this, body, optFns);
        }
    
        public CalendarPatchReqCall patch(Calendar body, RequestOptFn... optFns) {
            return new CalendarPatchReqCall(this, body, optFns);
        }
    
        public CalendarDeleteReqCall delete(RequestOptFn... optFns) {
            return new CalendarDeleteReqCall(this, optFns);
        }
    
        public CalendarListReqCall list(RequestOptFn... optFns) {
            return new CalendarListReqCall(this, optFns);
        }
    
        public CalendarGetReqCall get(RequestOptFn... optFns) {
            return new CalendarGetReqCall(this, optFns);
        }
    
        public CalendarSearchReqCall search(CalendarSearchReqBody body, RequestOptFn... optFns) {
            return new CalendarSearchReqCall(this, body, optFns);
        }
    
        public CalendarUnsubscribeReqCall unsubscribe(RequestOptFn... optFns) {
            return new CalendarUnsubscribeReqCall(this, optFns);
        }
    
        public CalendarSubscribeReqCall subscribe(RequestOptFn... optFns) {
            return new CalendarSubscribeReqCall(this, optFns);
        }
    
        public CalendarSubscriptionReqCall subscription(RequestOptFn... optFns) {
            return new CalendarSubscriptionReqCall(this, optFns);
        }
    
    }
    public static class CalendarCreateReqCall extends ReqCaller<Calendar, CalendarCreateResult> {
        private final Calendars calendars;
        
        private final Calendar body;
        private final List<RequestOptFn> optFns;
        private CalendarCreateResult result;
        
        private CalendarCreateReqCall(Calendars calendars, Calendar body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarCreateResult();
            this.calendars = calendars;
        }
        

        @Override
        public Response<CalendarCreateResult> execute() throws Exception {
            Request<Calendar, CalendarCreateResult> request = Request.newRequest("calendar/v4/calendars", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendars.service.config, request);
        }
    }
    public static class CalendarPatchReqCall extends ReqCaller<Calendar, CalendarPatchResult> {
        private final Calendars calendars;
        
        private final Calendar body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private CalendarPatchResult result;
        
        private CalendarPatchReqCall(Calendars calendars, Calendar body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarPatchResult();
            this.calendars = calendars;
        }
        
        public CalendarPatchReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }

        @Override
        public Response<CalendarPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Calendar, CalendarPatchResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id", "PATCH",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendars.service.config, request);
        }
    }
    public static class CalendarDeleteReqCall extends ReqCaller<Object, EmptyData> {
        private final Calendars calendars;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private CalendarDeleteReqCall(Calendars calendars, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.calendars = calendars;
        }
        
        public CalendarDeleteReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("calendar/v4/calendars/:calendar_id", "DELETE",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendars.service.config, request);
        }
    }
    public static class CalendarListReqCall extends ReqCaller<Object, CalendarListResult> {
        private final Calendars calendars;
        
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private CalendarListResult result;
        
        private CalendarListReqCall(Calendars calendars, RequestOptFn... optFns) {
        
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarListResult();
            this.calendars = calendars;
        }
        
        
        public CalendarListReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }
        public CalendarListReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }
        public CalendarListReqCall setSyncToken(String syncToken){
            this.queryParams.put("sync_token", syncToken);
            return this;
        }

        @Override
        public Response<CalendarListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, CalendarListResult> request = Request.newRequest("calendar/v4/calendars", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendars.service.config, request);
        }
    }
    public static class CalendarGetReqCall extends ReqCaller<Object, Calendar> {
        private final Calendars calendars;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private Calendar result;
        
        private CalendarGetReqCall(Calendars calendars, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new Calendar();
            this.calendars = calendars;
        }
        
        public CalendarGetReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }

        @Override
        public Response<Calendar> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, Calendar> request = Request.newRequest("calendar/v4/calendars/:calendar_id", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendars.service.config, request);
        }
    }
    public static class CalendarSearchReqCall extends ReqCaller<CalendarSearchReqBody, CalendarSearchResult> {
        private final Calendars calendars;
        
        private final CalendarSearchReqBody body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private CalendarSearchResult result;
        
        private CalendarSearchReqCall(Calendars calendars, CalendarSearchReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarSearchResult();
            this.calendars = calendars;
        }
        
        
        public CalendarSearchReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }
        public CalendarSearchReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<CalendarSearchResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<CalendarSearchReqBody, CalendarSearchResult> request = Request.newRequest("calendar/v4/calendars/search", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendars.service.config, request);
        }
    }
    public static class CalendarUnsubscribeReqCall extends ReqCaller<Object, EmptyData> {
        private final Calendars calendars;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private CalendarUnsubscribeReqCall(Calendars calendars, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.calendars = calendars;
        }
        
        public CalendarUnsubscribeReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("calendar/v4/calendars/:calendar_id/unsubscribe", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendars.service.config, request);
        }
    }
    public static class CalendarSubscribeReqCall extends ReqCaller<Object, CalendarSubscribeResult> {
        private final Calendars calendars;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private CalendarSubscribeResult result;
        
        private CalendarSubscribeReqCall(Calendars calendars, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarSubscribeResult();
            this.calendars = calendars;
        }
        
        public CalendarSubscribeReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }

        @Override
        public Response<CalendarSubscribeResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, CalendarSubscribeResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/subscribe", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendars.service.config, request);
        }
    }
    public static class CalendarSubscriptionReqCall extends ReqCaller<Object, EmptyData> {
        private final Calendars calendars;
        
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private CalendarSubscriptionReqCall(Calendars calendars, RequestOptFn... optFns) {
        
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.calendars = calendars;
        }
        

        @Override
        public Response<EmptyData> execute() throws Exception {
            Request<Object, EmptyData> request = Request.newRequest("calendar/v4/calendars/subscription", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendars.service.config, request);
        }
    }

    public CalendarAcls getCalendarAcls() {
        return calendarAcls;
    }

    public static class CalendarAcls {

        private final CalendarService service;

        public CalendarAcls(CalendarService service) {
            this.service = service;
        }
    
        public CalendarAclListReqCall list(RequestOptFn... optFns) {
            return new CalendarAclListReqCall(this, optFns);
        }
    
        public CalendarAclDeleteReqCall delete(RequestOptFn... optFns) {
            return new CalendarAclDeleteReqCall(this, optFns);
        }
    
        public CalendarAclCreateReqCall create(CalendarAcl body, RequestOptFn... optFns) {
            return new CalendarAclCreateReqCall(this, body, optFns);
        }
    
        public CalendarAclSubscriptionReqCall subscription(RequestOptFn... optFns) {
            return new CalendarAclSubscriptionReqCall(this, optFns);
        }
    
    }
    public static class CalendarAclListReqCall extends ReqCaller<Object, CalendarAclListResult> {
        private final CalendarAcls calendarAcls;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private CalendarAclListResult result;
        
        private CalendarAclListReqCall(CalendarAcls calendarAcls, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarAclListResult();
            this.calendarAcls = calendarAcls;
        }
        
        public CalendarAclListReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        
        public CalendarAclListReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }
        public CalendarAclListReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }
        public CalendarAclListReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<CalendarAclListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, CalendarAclListResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/acls", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarAcls.service.config, request);
        }
    }
    public static class CalendarAclDeleteReqCall extends ReqCaller<Object, EmptyData> {
        private final CalendarAcls calendarAcls;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private CalendarAclDeleteReqCall(CalendarAcls calendarAcls, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.calendarAcls = calendarAcls;
        }
        
        public CalendarAclDeleteReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        public CalendarAclDeleteReqCall setAclId(String aclId){
            this.pathParams.put("acl_id", aclId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("calendar/v4/calendars/:calendar_id/acls/:acl_id", "DELETE",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarAcls.service.config, request);
        }
    }
    public static class CalendarAclCreateReqCall extends ReqCaller<CalendarAcl, CalendarAcl> {
        private final CalendarAcls calendarAcls;
        
        private final CalendarAcl body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private CalendarAcl result;
        
        private CalendarAclCreateReqCall(CalendarAcls calendarAcls, CalendarAcl body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarAcl();
            this.calendarAcls = calendarAcls;
        }
        
        public CalendarAclCreateReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        
        public CalendarAclCreateReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<CalendarAcl> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<CalendarAcl, CalendarAcl> request = Request.newRequest("calendar/v4/calendars/:calendar_id/acls", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarAcls.service.config, request);
        }
    }
    public static class CalendarAclSubscriptionReqCall extends ReqCaller<Object, EmptyData> {
        private final CalendarAcls calendarAcls;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private CalendarAclSubscriptionReqCall(CalendarAcls calendarAcls, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.calendarAcls = calendarAcls;
        }
        
        public CalendarAclSubscriptionReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("calendar/v4/calendars/:calendar_id/acls/subscription", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarAcls.service.config, request);
        }
    }

    public CalendarEvents getCalendarEvents() {
        return calendarEvents;
    }

    public static class CalendarEvents {

        private final CalendarService service;

        public CalendarEvents(CalendarService service) {
            this.service = service;
        }
    
        public CalendarEventDeleteReqCall delete(RequestOptFn... optFns) {
            return new CalendarEventDeleteReqCall(this, optFns);
        }
    
        public CalendarEventGetReqCall get(RequestOptFn... optFns) {
            return new CalendarEventGetReqCall(this, optFns);
        }
    
        public CalendarEventCreateReqCall create(CalendarEvent body, RequestOptFn... optFns) {
            return new CalendarEventCreateReqCall(this, body, optFns);
        }
    
        public CalendarEventListReqCall list(RequestOptFn... optFns) {
            return new CalendarEventListReqCall(this, optFns);
        }
    
        public CalendarEventPatchReqCall patch(CalendarEvent body, RequestOptFn... optFns) {
            return new CalendarEventPatchReqCall(this, body, optFns);
        }
    
        public CalendarEventSearchReqCall search(CalendarEventSearchReqBody body, RequestOptFn... optFns) {
            return new CalendarEventSearchReqCall(this, body, optFns);
        }
    
        public CalendarEventSubscriptionReqCall subscription(RequestOptFn... optFns) {
            return new CalendarEventSubscriptionReqCall(this, optFns);
        }
    
    }
    public static class CalendarEventDeleteReqCall extends ReqCaller<Object, EmptyData> {
        private final CalendarEvents calendarEvents;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private CalendarEventDeleteReqCall(CalendarEvents calendarEvents, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.calendarEvents = calendarEvents;
        }
        
        public CalendarEventDeleteReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        public CalendarEventDeleteReqCall setEventId(String eventId){
            this.pathParams.put("event_id", eventId);
            return this;
        }
        
        public CalendarEventDeleteReqCall setNeedNotification(Boolean needNotification){
            this.queryParams.put("need_notification", needNotification);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmptyData> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events/:event_id", "DELETE",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEvents.service.config, request);
        }
    }
    public static class CalendarEventGetReqCall extends ReqCaller<Object, CalendarEventGetResult> {
        private final CalendarEvents calendarEvents;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private CalendarEventGetResult result;
        
        private CalendarEventGetReqCall(CalendarEvents calendarEvents, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarEventGetResult();
            this.calendarEvents = calendarEvents;
        }
        
        public CalendarEventGetReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        public CalendarEventGetReqCall setEventId(String eventId){
            this.pathParams.put("event_id", eventId);
            return this;
        }

        @Override
        public Response<CalendarEventGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, CalendarEventGetResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events/:event_id", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEvents.service.config, request);
        }
    }
    public static class CalendarEventCreateReqCall extends ReqCaller<CalendarEvent, CalendarEventCreateResult> {
        private final CalendarEvents calendarEvents;
        
        private final CalendarEvent body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private CalendarEventCreateResult result;
        
        private CalendarEventCreateReqCall(CalendarEvents calendarEvents, CalendarEvent body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarEventCreateResult();
            this.calendarEvents = calendarEvents;
        }
        
        public CalendarEventCreateReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }

        @Override
        public Response<CalendarEventCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<CalendarEvent, CalendarEventCreateResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEvents.service.config, request);
        }
    }
    public static class CalendarEventListReqCall extends ReqCaller<Object, CalendarEventListResult> {
        private final CalendarEvents calendarEvents;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private CalendarEventListResult result;
        
        private CalendarEventListReqCall(CalendarEvents calendarEvents, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarEventListResult();
            this.calendarEvents = calendarEvents;
        }
        
        public CalendarEventListReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        
        public CalendarEventListReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }
        public CalendarEventListReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }
        public CalendarEventListReqCall setSyncToken(String syncToken){
            this.queryParams.put("sync_token", syncToken);
            return this;
        }

        @Override
        public Response<CalendarEventListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, CalendarEventListResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEvents.service.config, request);
        }
    }
    public static class CalendarEventPatchReqCall extends ReqCaller<CalendarEvent, CalendarEventPatchResult> {
        private final CalendarEvents calendarEvents;
        
        private final CalendarEvent body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private CalendarEventPatchResult result;
        
        private CalendarEventPatchReqCall(CalendarEvents calendarEvents, CalendarEvent body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarEventPatchResult();
            this.calendarEvents = calendarEvents;
        }
        
        public CalendarEventPatchReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        public CalendarEventPatchReqCall setEventId(String eventId){
            this.pathParams.put("event_id", eventId);
            return this;
        }

        @Override
        public Response<CalendarEventPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<CalendarEvent, CalendarEventPatchResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events/:event_id", "PATCH",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEvents.service.config, request);
        }
    }
    public static class CalendarEventSearchReqCall extends ReqCaller<CalendarEventSearchReqBody, CalendarEventSearchResult> {
        private final CalendarEvents calendarEvents;
        
        private final CalendarEventSearchReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private CalendarEventSearchResult result;
        
        private CalendarEventSearchReqCall(CalendarEvents calendarEvents, CalendarEventSearchReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarEventSearchResult();
            this.calendarEvents = calendarEvents;
        }
        
        public CalendarEventSearchReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        
        public CalendarEventSearchReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }
        public CalendarEventSearchReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }
        public CalendarEventSearchReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<CalendarEventSearchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<CalendarEventSearchReqBody, CalendarEventSearchResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events/search", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEvents.service.config, request);
        }
    }
    public static class CalendarEventSubscriptionReqCall extends ReqCaller<Object, EmptyData> {
        private final CalendarEvents calendarEvents;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private CalendarEventSubscriptionReqCall(CalendarEvents calendarEvents, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.calendarEvents = calendarEvents;
        }
        
        public CalendarEventSubscriptionReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events/subscription", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEvents.service.config, request);
        }
    }

    public CalendarEventAttendees getCalendarEventAttendees() {
        return calendarEventAttendees;
    }

    public static class CalendarEventAttendees {

        private final CalendarService service;

        public CalendarEventAttendees(CalendarService service) {
            this.service = service;
        }
    
        public CalendarEventAttendeeListReqCall list(RequestOptFn... optFns) {
            return new CalendarEventAttendeeListReqCall(this, optFns);
        }
    
        public CalendarEventAttendeeBatchDeleteReqCall batchDelete(CalendarEventAttendeeBatchDeleteReqBody body, RequestOptFn... optFns) {
            return new CalendarEventAttendeeBatchDeleteReqCall(this, body, optFns);
        }
    
        public CalendarEventAttendeeCreateReqCall create(CalendarEventAttendeeCreateReqBody body, RequestOptFn... optFns) {
            return new CalendarEventAttendeeCreateReqCall(this, body, optFns);
        }
    
    }
    public static class CalendarEventAttendeeListReqCall extends ReqCaller<Object, CalendarEventAttendeeListResult> {
        private final CalendarEventAttendees calendarEventAttendees;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private CalendarEventAttendeeListResult result;
        
        private CalendarEventAttendeeListReqCall(CalendarEventAttendees calendarEventAttendees, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarEventAttendeeListResult();
            this.calendarEventAttendees = calendarEventAttendees;
        }
        
        public CalendarEventAttendeeListReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        public CalendarEventAttendeeListReqCall setEventId(String eventId){
            this.pathParams.put("event_id", eventId);
            return this;
        }
        
        public CalendarEventAttendeeListReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }
        public CalendarEventAttendeeListReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }
        public CalendarEventAttendeeListReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<CalendarEventAttendeeListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, CalendarEventAttendeeListResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events/:event_id/attendees", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEventAttendees.service.config, request);
        }
    }
    public static class CalendarEventAttendeeBatchDeleteReqCall extends ReqCaller<CalendarEventAttendeeBatchDeleteReqBody, EmptyData> {
        private final CalendarEventAttendees calendarEventAttendees;
        
        private final CalendarEventAttendeeBatchDeleteReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private CalendarEventAttendeeBatchDeleteReqCall(CalendarEventAttendees calendarEventAttendees, CalendarEventAttendeeBatchDeleteReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.calendarEventAttendees = calendarEventAttendees;
        }
        
        public CalendarEventAttendeeBatchDeleteReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        public CalendarEventAttendeeBatchDeleteReqCall setEventId(String eventId){
            this.pathParams.put("event_id", eventId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<CalendarEventAttendeeBatchDeleteReqBody, EmptyData> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events/:event_id/attendees/batch_delete", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEventAttendees.service.config, request);
        }
    }
    public static class CalendarEventAttendeeCreateReqCall extends ReqCaller<CalendarEventAttendeeCreateReqBody, CalendarEventAttendeeCreateResult> {
        private final CalendarEventAttendees calendarEventAttendees;
        
        private final CalendarEventAttendeeCreateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private CalendarEventAttendeeCreateResult result;
        
        private CalendarEventAttendeeCreateReqCall(CalendarEventAttendees calendarEventAttendees, CalendarEventAttendeeCreateReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarEventAttendeeCreateResult();
            this.calendarEventAttendees = calendarEventAttendees;
        }
        
        public CalendarEventAttendeeCreateReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        public CalendarEventAttendeeCreateReqCall setEventId(String eventId){
            this.pathParams.put("event_id", eventId);
            return this;
        }
        
        public CalendarEventAttendeeCreateReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<CalendarEventAttendeeCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<CalendarEventAttendeeCreateReqBody, CalendarEventAttendeeCreateResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events/:event_id/attendees", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEventAttendees.service.config, request);
        }
    }

    public CalendarEventAttendeeChatMembers getCalendarEventAttendeeChatMembers() {
        return calendarEventAttendeeChatMembers;
    }

    public static class CalendarEventAttendeeChatMembers {

        private final CalendarService service;

        public CalendarEventAttendeeChatMembers(CalendarService service) {
            this.service = service;
        }
    
        public CalendarEventAttendeeChatMemberListReqCall list(RequestOptFn... optFns) {
            return new CalendarEventAttendeeChatMemberListReqCall(this, optFns);
        }
    
    }
    public static class CalendarEventAttendeeChatMemberListReqCall extends ReqCaller<Object, CalendarEventAttendeeChatMemberListResult> {
        private final CalendarEventAttendeeChatMembers calendarEventAttendeeChatMembers;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private CalendarEventAttendeeChatMemberListResult result;
        
        private CalendarEventAttendeeChatMemberListReqCall(CalendarEventAttendeeChatMembers calendarEventAttendeeChatMembers, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CalendarEventAttendeeChatMemberListResult();
            this.calendarEventAttendeeChatMembers = calendarEventAttendeeChatMembers;
        }
        
        public CalendarEventAttendeeChatMemberListReqCall setCalendarId(String calendarId){
            this.pathParams.put("calendar_id", calendarId);
            return this;
        }
        public CalendarEventAttendeeChatMemberListReqCall setEventId(String eventId){
            this.pathParams.put("event_id", eventId);
            return this;
        }
        public CalendarEventAttendeeChatMemberListReqCall setAttendeeId(String attendeeId){
            this.pathParams.put("attendee_id", attendeeId);
            return this;
        }
        
        public CalendarEventAttendeeChatMemberListReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }
        public CalendarEventAttendeeChatMemberListReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<CalendarEventAttendeeChatMemberListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, CalendarEventAttendeeChatMemberListResult> request = Request.newRequest("calendar/v4/calendars/:calendar_id/events/:event_id/attendees/:attendee_id/chat_members", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.calendarEventAttendeeChatMembers.service.config, request);
        }
    }

    public Freebusys getFreebusys() {
        return freebusys;
    }

    public static class Freebusys {

        private final CalendarService service;

        public Freebusys(CalendarService service) {
            this.service = service;
        }
    
        public FreebusyListReqCall list(FreebusyListReqBody body, RequestOptFn... optFns) {
            return new FreebusyListReqCall(this, body, optFns);
        }
    
    }
    public static class FreebusyListReqCall extends ReqCaller<FreebusyListReqBody, FreebusyListResult> {
        private final Freebusys freebusys;
        
        private final FreebusyListReqBody body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private FreebusyListResult result;
        
        private FreebusyListReqCall(Freebusys freebusys, FreebusyListReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FreebusyListResult();
            this.freebusys = freebusys;
        }
        
        
        public FreebusyListReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<FreebusyListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<FreebusyListReqBody, FreebusyListResult> request = Request.newRequest("calendar/v4/freebusy/list", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.freebusys.service.config, request);
        }
    }

    public Settings getSettings() {
        return settings;
    }

    public static class Settings {

        private final CalendarService service;

        public Settings(CalendarService service) {
            this.service = service;
        }
    
        public SettingGenerateCaldavConfReqCall generateCaldavConf(SettingGenerateCaldavConfReqBody body, RequestOptFn... optFns) {
            return new SettingGenerateCaldavConfReqCall(this, body, optFns);
        }
    
    }
    public static class SettingGenerateCaldavConfReqCall extends ReqCaller<SettingGenerateCaldavConfReqBody, SettingGenerateCaldavConfResult> {
        private final Settings settings;
        
        private final SettingGenerateCaldavConfReqBody body;
        private final List<RequestOptFn> optFns;
        private SettingGenerateCaldavConfResult result;
        
        private SettingGenerateCaldavConfReqCall(Settings settings, SettingGenerateCaldavConfReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new SettingGenerateCaldavConfResult();
            this.settings = settings;
        }
        

        @Override
        public Response<SettingGenerateCaldavConfResult> execute() throws Exception {
            Request<SettingGenerateCaldavConfReqBody, SettingGenerateCaldavConfResult> request = Request.newRequest("calendar/v4/settings/generate_caldav_conf", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.settings.service.config, request);
        }
    }

    public TimeoffEvents getTimeoffEvents() {
        return timeoffEvents;
    }

    public static class TimeoffEvents {

        private final CalendarService service;

        public TimeoffEvents(CalendarService service) {
            this.service = service;
        }
    
        public TimeoffEventDeleteReqCall delete(RequestOptFn... optFns) {
            return new TimeoffEventDeleteReqCall(this, optFns);
        }
    
        public TimeoffEventCreateReqCall create(TimeoffEvent body, RequestOptFn... optFns) {
            return new TimeoffEventCreateReqCall(this, body, optFns);
        }
    
    }
    public static class TimeoffEventDeleteReqCall extends ReqCaller<Object, EmptyData> {
        private final TimeoffEvents timeoffEvents;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private TimeoffEventDeleteReqCall(TimeoffEvents timeoffEvents, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.timeoffEvents = timeoffEvents;
        }
        
        public TimeoffEventDeleteReqCall setTimeoffEventId(String timeoffEventId){
            this.pathParams.put("timeoff_event_id", timeoffEventId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("calendar/v4/timeoff_events/:timeoff_event_id", "DELETE",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.timeoffEvents.service.config, request);
        }
    }
    public static class TimeoffEventCreateReqCall extends ReqCaller<TimeoffEvent, TimeoffEvent> {
        private final TimeoffEvents timeoffEvents;
        
        private final TimeoffEvent body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private TimeoffEvent result;
        
        private TimeoffEventCreateReqCall(TimeoffEvents timeoffEvents, TimeoffEvent body, RequestOptFn... optFns) {
        
            this.body = body;
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TimeoffEvent();
            this.timeoffEvents = timeoffEvents;
        }
        
        
        public TimeoffEventCreateReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<TimeoffEvent> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<TimeoffEvent, TimeoffEvent> request = Request.newRequest("calendar/v4/timeoff_events", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.timeoffEvents.service.config, request);
        }
    }

    public ExchangeBindings getExchangeBindings() {
        return exchangeBindings;
    }

    public static class ExchangeBindings {

        private final CalendarService service;

        public ExchangeBindings(CalendarService service) {
            this.service = service;
        }
    
        public ExchangeBindingCreateReqCall create(ExchangeBinding body, RequestOptFn... optFns) {
            return new ExchangeBindingCreateReqCall(this, body, optFns);
        }
    
        public ExchangeBindingDeleteReqCall delete(RequestOptFn... optFns) {
            return new ExchangeBindingDeleteReqCall(this, optFns);
        }
    
        public ExchangeBindingGetReqCall get(RequestOptFn... optFns) {
            return new ExchangeBindingGetReqCall(this, optFns);
        }
    
    }
    public static class ExchangeBindingCreateReqCall extends ReqCaller<ExchangeBinding, ExchangeBinding> {
        private final ExchangeBindings exchangeBindings;
        
        private final ExchangeBinding body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private ExchangeBinding result;
        
        private ExchangeBindingCreateReqCall(ExchangeBindings exchangeBindings, ExchangeBinding body, RequestOptFn... optFns) {
        
            this.body = body;
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ExchangeBinding();
            this.exchangeBindings = exchangeBindings;
        }
        
        
        public ExchangeBindingCreateReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<ExchangeBinding> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<ExchangeBinding, ExchangeBinding> request = Request.newRequest("calendar/v4/exchange_bindings", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.exchangeBindings.service.config, request);
        }
    }
    public static class ExchangeBindingDeleteReqCall extends ReqCaller<Object, EmptyData> {
        private final ExchangeBindings exchangeBindings;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private ExchangeBindingDeleteReqCall(ExchangeBindings exchangeBindings, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.exchangeBindings = exchangeBindings;
        }
        
        public ExchangeBindingDeleteReqCall setExchangeBindingId(String exchangeBindingId){
            this.pathParams.put("exchange_binding_id", exchangeBindingId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("calendar/v4/exchange_bindings/:exchange_binding_id", "DELETE",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.exchangeBindings.service.config, request);
        }
    }
    public static class ExchangeBindingGetReqCall extends ReqCaller<Object, ExchangeBinding> {
        private final ExchangeBindings exchangeBindings;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private ExchangeBinding result;
        
        private ExchangeBindingGetReqCall(ExchangeBindings exchangeBindings, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ExchangeBinding();
            this.exchangeBindings = exchangeBindings;
        }
        
        public ExchangeBindingGetReqCall setExchangeBindingId(String exchangeBindingId){
            this.pathParams.put("exchange_binding_id", exchangeBindingId);
            return this;
        }
        
        public ExchangeBindingGetReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<ExchangeBinding> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, ExchangeBinding> request = Request.newRequest("calendar/v4/exchange_bindings/:exchange_binding_id", "GET",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.exchangeBindings.service.config, request);
        }
    }

}
