// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.drive.v1;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.drive.v1.model.*;
import java.io.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class DriveService {

    private final Config config;
    private final Files files;
    private final FileComments fileComments;
    private final FileCommentReplys fileCommentReplys;
    private final Medias medias;

    public DriveService(Config config) {
        this.config = config;
        this.files = new Files(this);
        this.fileComments = new FileComments(this);
        this.fileCommentReplys = new FileCommentReplys(this);
        this.medias = new Medias(this);
    }

    public Files getFiles() {
        return files;
    }

    public static class Files {

        private final DriveService service;

        public Files(DriveService service) {
            this.service = service;
        }
    
        public FileUploadFinishReqCall uploadFinish(FileUploadFinishReqBody body, RequestOptFn... optFns) {
            return new FileUploadFinishReqCall(this, body, optFns);
        }
    
        public FileUploadPrepareReqCall uploadPrepare(UploadInfo body, RequestOptFn... optFns) {
            return new FileUploadPrepareReqCall(this, body, optFns);
        }
    
        public FileUploadAllReqCall uploadAll(RequestOptFn... optFns) {
            return new FileUploadAllReqCall(this, optFns);
        }
    
        public FileUploadPartReqCall uploadPart(RequestOptFn... optFns) {
            return new FileUploadPartReqCall(this, optFns);
        }
    
        public FileDownloadReqCall download(RequestOptFn... optFns) {
            return new FileDownloadReqCall(this, optFns);
        }
    
        public FileSubscribeReqCall subscribe(RequestOptFn... optFns) {
            return new FileSubscribeReqCall(this, optFns);
        }
    
    }
    public static class FileUploadFinishReqCall extends ReqCaller<FileUploadFinishReqBody, FileUploadFinishResult> {
        private final Files files;
        
        private final FileUploadFinishReqBody body;
        private final List<RequestOptFn> optFns;
        private FileUploadFinishResult result;
        
        private FileUploadFinishReqCall(Files files, FileUploadFinishReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileUploadFinishResult();
            this.files = files;
        }
        

        @Override
        public Response<FileUploadFinishResult> execute() throws Exception {
            Request<FileUploadFinishReqBody, FileUploadFinishResult> request = Request.newRequest("drive/v1/files/upload_finish", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }
    public static class FileUploadPrepareReqCall extends ReqCaller<UploadInfo, FileUploadPrepareResult> {
        private final Files files;
        
        private final UploadInfo body;
        private final List<RequestOptFn> optFns;
        private FileUploadPrepareResult result;
        
        private FileUploadPrepareReqCall(Files files, UploadInfo body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileUploadPrepareResult();
            this.files = files;
        }
        

        @Override
        public Response<FileUploadPrepareResult> execute() throws Exception {
            Request<UploadInfo, FileUploadPrepareResult> request = Request.newRequest("drive/v1/files/upload_prepare", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }
    public static class FileUploadAllReqCall extends ReqCaller<FormData, FileUploadAllResult> {
        private final Files files;
        private final FormData body;
        private final List<RequestOptFn> optFns;
        private FileUploadAllResult result;
        
        private FileUploadAllReqCall(Files files, RequestOptFn... optFns) {
        
            this.body = new FormData();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileUploadAllResult();
            this.files = files;
        }
        
        
        public FileUploadAllReqCall setFileName(String fileName){
            this.body.addField("file_name", fileName);
            return this;
        }
        
        public FileUploadAllReqCall setParentType(String parentType){
            this.body.addField("parent_type", parentType);
            return this;
        }
        
        public FileUploadAllReqCall setParentNode(String parentNode){
            this.body.addField("parent_node", parentNode);
            return this;
        }
        
        public FileUploadAllReqCall setSize(Integer size){
            this.body.addField("size", size);
            return this;
        }
        
        public FileUploadAllReqCall setChecksum(String checksum){
            this.body.addField("checksum", checksum);
            return this;
        }
        
        public FileUploadAllReqCall setFile(FormDataFile file){
            this.body.addFile("file", file);
            return this;
        }
        

        @Override
        public Response<FileUploadAllResult> execute() throws Exception {
            Request<FormData, FileUploadAllResult> request = Request.newRequest("drive/v1/files/upload_all", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }
    public static class FileUploadPartReqCall extends ReqCaller<FormData, EmptyData> {
        private final Files files;
        private final FormData body;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private FileUploadPartReqCall(Files files, RequestOptFn... optFns) {
        
            this.body = new FormData();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.files = files;
        }
        
        
        public FileUploadPartReqCall setUploadId(String uploadId){
            this.body.addField("upload_id", uploadId);
            return this;
        }
        
        public FileUploadPartReqCall setSeq(Integer seq){
            this.body.addField("seq", seq);
            return this;
        }
        
        public FileUploadPartReqCall setSize(Integer size){
            this.body.addField("size", size);
            return this;
        }
        
        public FileUploadPartReqCall setChecksum(String checksum){
            this.body.addField("checksum", checksum);
            return this;
        }
        
        public FileUploadPartReqCall setFile(FormDataFile file){
            this.body.addFile("file", file);
            return this;
        }
        

        @Override
        public Response<EmptyData> execute() throws Exception {
            Request<FormData, EmptyData> request = Request.newRequest("drive/v1/files/upload_part", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }
    public static class FileDownloadReqCall extends ReqCaller<Object, OutputStream> {
        private final Files files;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private OutputStream result;
        
        private FileDownloadReqCall(Files files, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.files = files;
        }
        
        public FileDownloadReqCall setFileToken(String fileToken){
            this.pathParams.put("file_token", fileToken);
            return this;
        }
        public FileDownloadReqCall setResponseStream(OutputStream result){
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("drive/v1/files/:file_token/download", "GET",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }
    public static class FileSubscribeReqCall extends ReqCaller<Object, EmptyData> {
        private final Files files;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private FileSubscribeReqCall(Files files, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.files = files;
        }
        
        public FileSubscribeReqCall setFileToken(String fileToken){
            this.pathParams.put("file_token", fileToken);
            return this;
        }
        
        public FileSubscribeReqCall setFileType(String fileType){
            this.queryParams.put("file_type", fileType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmptyData> request = Request.newRequest("drive/v1/files/:file_token/subscribe", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }

    public FileComments getFileComments() {
        return fileComments;
    }

    public static class FileComments {

        private final DriveService service;

        public FileComments(DriveService service) {
            this.service = service;
        }
    
        public FileCommentCreateReqCall create(FileComment body, RequestOptFn... optFns) {
            return new FileCommentCreateReqCall(this, body, optFns);
        }
    
        public FileCommentGetReqCall get(RequestOptFn... optFns) {
            return new FileCommentGetReqCall(this, optFns);
        }
    
        public FileCommentListReqCall list(RequestOptFn... optFns) {
            return new FileCommentListReqCall(this, optFns);
        }
    
        public FileCommentPatchReqCall patch(FileCommentPatchReqBody body, RequestOptFn... optFns) {
            return new FileCommentPatchReqCall(this, body, optFns);
        }
    
    }
    public static class FileCommentCreateReqCall extends ReqCaller<FileComment, FileComment> {
        private final FileComments fileComments;
        
        private final FileComment body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private FileComment result;
        
        private FileCommentCreateReqCall(FileComments fileComments, FileComment body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileComment();
            this.fileComments = fileComments;
        }
        
        public FileCommentCreateReqCall setFileToken(String fileToken){
            this.pathParams.put("file_token", fileToken);
            return this;
        }
        
        public FileCommentCreateReqCall setFileType(String fileType){
            this.queryParams.put("file_type", fileType);
            return this;
        }
        public FileCommentCreateReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<FileComment> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<FileComment, FileComment> request = Request.newRequest("drive/v1/files/:file_token/comments", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.fileComments.service.config, request);
        }
    }
    public static class FileCommentGetReqCall extends ReqCaller<Object, FileComment> {
        private final FileComments fileComments;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private FileComment result;
        
        private FileCommentGetReqCall(FileComments fileComments, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileComment();
            this.fileComments = fileComments;
        }
        
        public FileCommentGetReqCall setFileToken(String fileToken){
            this.pathParams.put("file_token", fileToken);
            return this;
        }
        public FileCommentGetReqCall setCommentId(Long commentId){
            this.pathParams.put("comment_id", commentId);
            return this;
        }
        
        public FileCommentGetReqCall setFileType(String fileType){
            this.queryParams.put("file_type", fileType);
            return this;
        }
        public FileCommentGetReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<FileComment> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, FileComment> request = Request.newRequest("drive/v1/files/:file_token/comments/:comment_id", "GET",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.fileComments.service.config, request);
        }
    }
    public static class FileCommentListReqCall extends ReqCaller<Object, FileCommentListResult> {
        private final FileComments fileComments;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private FileCommentListResult result;
        
        private FileCommentListReqCall(FileComments fileComments, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileCommentListResult();
            this.fileComments = fileComments;
        }
        
        public FileCommentListReqCall setFileToken(String fileToken){
            this.pathParams.put("file_token", fileToken);
            return this;
        }
        
        public FileCommentListReqCall setFileType(String fileType){
            this.queryParams.put("file_type", fileType);
            return this;
        }
        public FileCommentListReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }
        public FileCommentListReqCall setIsSolved(Boolean isSolved){
            this.queryParams.put("is_solved", isSolved);
            return this;
        }
        public FileCommentListReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }
        public FileCommentListReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<FileCommentListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, FileCommentListResult> request = Request.newRequest("drive/v1/files/:file_token/comments", "GET",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.fileComments.service.config, request);
        }
    }
    public static class FileCommentPatchReqCall extends ReqCaller<FileCommentPatchReqBody, EmptyData> {
        private final FileComments fileComments;
        
        private final FileCommentPatchReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private FileCommentPatchReqCall(FileComments fileComments, FileCommentPatchReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.fileComments = fileComments;
        }
        
        public FileCommentPatchReqCall setFileToken(String fileToken){
            this.pathParams.put("file_token", fileToken);
            return this;
        }
        public FileCommentPatchReqCall setCommentId(Long commentId){
            this.pathParams.put("comment_id", commentId);
            return this;
        }
        
        public FileCommentPatchReqCall setFileType(String fileType){
            this.queryParams.put("file_type", fileType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<FileCommentPatchReqBody, EmptyData> request = Request.newRequest("drive/v1/files/:file_token/comments/:comment_id", "PATCH",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.fileComments.service.config, request);
        }
    }

    public FileCommentReplys getFileCommentReplys() {
        return fileCommentReplys;
    }

    public static class FileCommentReplys {

        private final DriveService service;

        public FileCommentReplys(DriveService service) {
            this.service = service;
        }
    
        public FileCommentReplyUpdateReqCall update(FileCommentReplyUpdateReqBody body, RequestOptFn... optFns) {
            return new FileCommentReplyUpdateReqCall(this, body, optFns);
        }
    
        public FileCommentReplyDeleteReqCall delete(RequestOptFn... optFns) {
            return new FileCommentReplyDeleteReqCall(this, optFns);
        }
    
    }
    public static class FileCommentReplyUpdateReqCall extends ReqCaller<FileCommentReplyUpdateReqBody, EmptyData> {
        private final FileCommentReplys fileCommentReplys;
        
        private final FileCommentReplyUpdateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private FileCommentReplyUpdateReqCall(FileCommentReplys fileCommentReplys, FileCommentReplyUpdateReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.fileCommentReplys = fileCommentReplys;
        }
        
        public FileCommentReplyUpdateReqCall setFileToken(String fileToken){
            this.pathParams.put("file_token", fileToken);
            return this;
        }
        public FileCommentReplyUpdateReqCall setCommentId(Long commentId){
            this.pathParams.put("comment_id", commentId);
            return this;
        }
        public FileCommentReplyUpdateReqCall setReplyId(Long replyId){
            this.pathParams.put("reply_id", replyId);
            return this;
        }
        
        public FileCommentReplyUpdateReqCall setFileType(String fileType){
            this.queryParams.put("file_type", fileType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<FileCommentReplyUpdateReqBody, EmptyData> request = Request.newRequest("drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id", "PUT",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.fileCommentReplys.service.config, request);
        }
    }
    public static class FileCommentReplyDeleteReqCall extends ReqCaller<Object, EmptyData> {
        private final FileCommentReplys fileCommentReplys;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private FileCommentReplyDeleteReqCall(FileCommentReplys fileCommentReplys, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.fileCommentReplys = fileCommentReplys;
        }
        
        public FileCommentReplyDeleteReqCall setFileToken(String fileToken){
            this.pathParams.put("file_token", fileToken);
            return this;
        }
        public FileCommentReplyDeleteReqCall setCommentId(Long commentId){
            this.pathParams.put("comment_id", commentId);
            return this;
        }
        public FileCommentReplyDeleteReqCall setReplyId(Long replyId){
            this.pathParams.put("reply_id", replyId);
            return this;
        }
        
        public FileCommentReplyDeleteReqCall setFileType(String fileType){
            this.queryParams.put("file_type", fileType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmptyData> request = Request.newRequest("drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id", "DELETE",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.fileCommentReplys.service.config, request);
        }
    }

    public Medias getMedias() {
        return medias;
    }

    public static class Medias {

        private final DriveService service;

        public Medias(DriveService service) {
            this.service = service;
        }
    
        public MediaUploadPartReqCall uploadPart(RequestOptFn... optFns) {
            return new MediaUploadPartReqCall(this, optFns);
        }
    
        public MediaUploadAllReqCall uploadAll(RequestOptFn... optFns) {
            return new MediaUploadAllReqCall(this, optFns);
        }
    
        public MediaUploadFinishReqCall uploadFinish(MediaUploadFinishReqBody body, RequestOptFn... optFns) {
            return new MediaUploadFinishReqCall(this, body, optFns);
        }
    
        public MediaUploadPrepareReqCall uploadPrepare(UploadInfo body, RequestOptFn... optFns) {
            return new MediaUploadPrepareReqCall(this, body, optFns);
        }
    
        public MediaBatchGetTmpDownloadUrlReqCall batchGetTmpDownloadUrl(RequestOptFn... optFns) {
            return new MediaBatchGetTmpDownloadUrlReqCall(this, optFns);
        }
    
        public MediaDownloadReqCall download(RequestOptFn... optFns) {
            return new MediaDownloadReqCall(this, optFns);
        }
    
    }
    public static class MediaUploadPartReqCall extends ReqCaller<FormData, EmptyData> {
        private final Medias medias;
        private final FormData body;
        private final List<RequestOptFn> optFns;
        private EmptyData result;
        
        private MediaUploadPartReqCall(Medias medias, RequestOptFn... optFns) {
        
            this.body = new FormData();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.medias = medias;
        }
        
        
        public MediaUploadPartReqCall setUploadId(String uploadId){
            this.body.addField("upload_id", uploadId);
            return this;
        }
        
        public MediaUploadPartReqCall setSeq(Integer seq){
            this.body.addField("seq", seq);
            return this;
        }
        
        public MediaUploadPartReqCall setSize(Integer size){
            this.body.addField("size", size);
            return this;
        }
        
        public MediaUploadPartReqCall setChecksum(String checksum){
            this.body.addField("checksum", checksum);
            return this;
        }
        
        public MediaUploadPartReqCall setFile(FormDataFile file){
            this.body.addFile("file", file);
            return this;
        }
        

        @Override
        public Response<EmptyData> execute() throws Exception {
            Request<FormData, EmptyData> request = Request.newRequest("drive/v1/medias/upload_part", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.medias.service.config, request);
        }
    }
    public static class MediaUploadAllReqCall extends ReqCaller<FormData, MediaUploadAllResult> {
        private final Medias medias;
        private final FormData body;
        private final List<RequestOptFn> optFns;
        private MediaUploadAllResult result;
        
        private MediaUploadAllReqCall(Medias medias, RequestOptFn... optFns) {
        
            this.body = new FormData();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MediaUploadAllResult();
            this.medias = medias;
        }
        
        
        public MediaUploadAllReqCall setFileName(String fileName){
            this.body.addField("file_name", fileName);
            return this;
        }
        
        public MediaUploadAllReqCall setParentType(String parentType){
            this.body.addField("parent_type", parentType);
            return this;
        }
        
        public MediaUploadAllReqCall setParentNode(String parentNode){
            this.body.addField("parent_node", parentNode);
            return this;
        }
        
        public MediaUploadAllReqCall setSize(Integer size){
            this.body.addField("size", size);
            return this;
        }
        
        public MediaUploadAllReqCall setChecksum(String checksum){
            this.body.addField("checksum", checksum);
            return this;
        }
        
        public MediaUploadAllReqCall setFile(FormDataFile file){
            this.body.addFile("file", file);
            return this;
        }
        

        @Override
        public Response<MediaUploadAllResult> execute() throws Exception {
            Request<FormData, MediaUploadAllResult> request = Request.newRequest("drive/v1/medias/upload_all", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.medias.service.config, request);
        }
    }
    public static class MediaUploadFinishReqCall extends ReqCaller<MediaUploadFinishReqBody, MediaUploadFinishResult> {
        private final Medias medias;
        
        private final MediaUploadFinishReqBody body;
        private final List<RequestOptFn> optFns;
        private MediaUploadFinishResult result;
        
        private MediaUploadFinishReqCall(Medias medias, MediaUploadFinishReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MediaUploadFinishResult();
            this.medias = medias;
        }
        

        @Override
        public Response<MediaUploadFinishResult> execute() throws Exception {
            Request<MediaUploadFinishReqBody, MediaUploadFinishResult> request = Request.newRequest("drive/v1/medias/upload_finish", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.medias.service.config, request);
        }
    }
    public static class MediaUploadPrepareReqCall extends ReqCaller<UploadInfo, MediaUploadPrepareResult> {
        private final Medias medias;
        
        private final UploadInfo body;
        private final List<RequestOptFn> optFns;
        private MediaUploadPrepareResult result;
        
        private MediaUploadPrepareReqCall(Medias medias, UploadInfo body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MediaUploadPrepareResult();
            this.medias = medias;
        }
        

        @Override
        public Response<MediaUploadPrepareResult> execute() throws Exception {
            Request<UploadInfo, MediaUploadPrepareResult> request = Request.newRequest("drive/v1/medias/upload_prepare", "POST",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.medias.service.config, request);
        }
    }
    public static class MediaBatchGetTmpDownloadUrlReqCall extends ReqCaller<Object, MediaBatchGetTmpDownloadUrlResult> {
        private final Medias medias;
        
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MediaBatchGetTmpDownloadUrlResult result;
        
        private MediaBatchGetTmpDownloadUrlReqCall(Medias medias, RequestOptFn... optFns) {
        
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MediaBatchGetTmpDownloadUrlResult();
            this.medias = medias;
        }
        
        
        public MediaBatchGetTmpDownloadUrlReqCall setFileTokens(String... fileTokens){
            this.queryParams.put("file_tokens", fileTokens);
            return this;
        }

        @Override
        public Response<MediaBatchGetTmpDownloadUrlResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MediaBatchGetTmpDownloadUrlResult> request = Request.newRequest("drive/v1/medias/batch_get_tmp_download_url", "GET",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.medias.service.config, request);
        }
    }
    public static class MediaDownloadReqCall extends ReqCaller<Object, OutputStream> {
        private final Medias medias;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private OutputStream result;
        
        private MediaDownloadReqCall(Medias medias, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.medias = medias;
        }
        
        public MediaDownloadReqCall setFileToken(String fileToken){
            this.pathParams.put("file_token", fileToken);
            return this;
        }
        public MediaDownloadReqCall setResponseStream(OutputStream result){
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("drive/v1/medias/:file_token/download", "GET",
                    new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.medias.service.config, request);
        }
    }
    public void setFileDeletedEventHandler(FileDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.deleted_v1", handler);
    }

    public abstract static class FileDeletedEventHandler implements IHandler<FileDeletedEvent> {
        @Override
        public FileDeletedEvent getEvent() {
            return new FileDeletedEvent();
        }
    }
    public void setFilePermissionMemberAddedEventHandler(FilePermissionMemberAddedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.permission_member_added_v1", handler);
    }

    public abstract static class FilePermissionMemberAddedEventHandler implements IHandler<FilePermissionMemberAddedEvent> {
        @Override
        public FilePermissionMemberAddedEvent getEvent() {
            return new FilePermissionMemberAddedEvent();
        }
    }
    public void setFilePermissionMemberRemovedEventHandler(FilePermissionMemberRemovedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.permission_member_removed_v1", handler);
    }

    public abstract static class FilePermissionMemberRemovedEventHandler implements IHandler<FilePermissionMemberRemovedEvent> {
        @Override
        public FilePermissionMemberRemovedEvent getEvent() {
            return new FilePermissionMemberRemovedEvent();
        }
    }
    public void setFileReadEventHandler(FileReadEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.read_v1", handler);
    }

    public abstract static class FileReadEventHandler implements IHandler<FileReadEvent> {
        @Override
        public FileReadEvent getEvent() {
            return new FileReadEvent();
        }
    }
    public void setFileTitleUpdatedEventHandler(FileTitleUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.title_updated_v1", handler);
    }

    public abstract static class FileTitleUpdatedEventHandler implements IHandler<FileTitleUpdatedEvent> {
        @Override
        public FileTitleUpdatedEvent getEvent() {
            return new FileTitleUpdatedEvent();
        }
    }
    public void setFileTrashedEventHandler(FileTrashedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.trashed_v1", handler);
    }

    public abstract static class FileTrashedEventHandler implements IHandler<FileTrashedEvent> {
        @Override
        public FileTrashedEvent getEvent() {
            return new FileTrashedEvent();
        }
    }

}
